/*
 * Decompiled with CFR 0.152.
 */
package test.pdfbox.pdmodel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdfparser.PDFStreamParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.fdf.FDFDocument;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDField;
import org.pdfbox.pdmodel.interactive.form.PDRadioCollection;
import org.pdfbox.pdmodel.interactive.form.PDTextbox;

public class TestFDF
extends TestCase {
    static /* synthetic */ Class class$test$pdfbox$pdmodel$TestFDF;

    public TestFDF(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$test$pdfbox$pdmodel$TestFDF == null ? (class$test$pdfbox$pdmodel$TestFDF = TestFDF.class$("test.pdfbox.pdmodel.TestFDF")) : class$test$pdfbox$pdmodel$TestFDF);
    }

    public static void main(String[] args) {
        String[] arg = new String[]{(class$test$pdfbox$pdmodel$TestFDF == null ? (class$test$pdfbox$pdmodel$TestFDF = TestFDF.class$("test.pdfbox.pdmodel.TestFDF")) : class$test$pdfbox$pdmodel$TestFDF).getName()};
        TestRunner.main((String[])arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFDFfdeb() throws Exception {
        PDDocument fdeb = null;
        try {
            fdeb = PDDocument.load("test/input/fdeb.pdf");
            PDAcroForm form = fdeb.getDocumentCatalog().getAcroForm();
            PDTextbox field = (PDTextbox)form.getField("f67_1");
            field.setValue("2");
            String expected = "/Tx BMC BT /Helv 9 Tf  0 g  2 1.985585 Td 2.07698 0 Td (2) Tj ET EMC";
            this.testContentStreams(fdeb, field, expected);
        }
        finally {
            if (fdeb != null) {
                fdeb.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFDFPDFWithLotsOfFields() throws Exception {
        PDDocument fdeb = null;
        try {
            fdeb = PDDocument.load("test/input/pdf_with_lots_of_fields.pdf");
            PDAcroForm form = fdeb.getDocumentCatalog().getAcroForm();
            PDTextbox feld2 = (PDTextbox)form.getField("Feld.2");
            feld2.setValue("Benjamin");
            String expected = "1 1 0.8000000119 rg  0 0 127.5 19.8299999237 re  f  0 0 0 RG  1 w  0.5 0.5 126.5 18.8299999237 re  S  0.5 g  1 1 m  1 18.8299999237 l  126.5 18.8299999237 l  125.5 17.8299999237 l  2 17.8299999237 l  2 2 l  1 1 l  f  0.75 g  1 1 m  126.5 1 l  126.5 18.8299999237 l  125.5 17.8299999237 l  125.5 2 l  2 2 l  1 1 l  f  /Tx BMC  BT /Helv 14 Tf  0 0 0 rg  4 4.721 Td (Benjamin) Tj ET EMC";
            this.testContentStreams(fdeb, feld2, expected);
            PDRadioCollection feld3 = (PDRadioCollection)form.getField("Feld.3");
            feld3.setValue("RB1");
            TestFDF.assertEquals((String)"RB1", (String)feld3.getValue());
        }
        finally {
            if (fdeb != null) {
                fdeb.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFDFFreedomExpressions() throws Exception {
        FDFDocument fdf;
        block5: {
            PDDocument freedom = null;
            fdf = null;
            try {
                freedom = PDDocument.load("test/input/FreedomExpressions.pdf");
                fdf = FDFDocument.load("test/input/FreedomExpressions.fdf");
                PDAcroForm form = freedom.getDocumentCatalog().getAcroForm();
                form.importFDF(fdf);
                PDTextbox feld2 = (PDTextbox)form.getField("eeFirstName");
                List kids = feld2.getKids();
                PDField firstKid = (PDField)kids.get(0);
                PDField secondKid = (PDField)kids.get(1);
                this.testContentStreamContains(freedom, firstKid, "Steve");
                this.testContentStreamContains(freedom, secondKid, "Steve");
                PDField totalAmt = form.getField("eeSuppTotalAmt");
                TestFDF.assertTrue((totalAmt.getDictionary().getDictionaryObject("AP") == null ? 1 : 0) != 0);
                Object var10_9 = null;
                if (freedom == null) break block5;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (freedom != null) {
                    freedom.close();
                }
                if (fdf != null) {
                    fdf.close();
                }
                throw throwable;
            }
            freedom.close();
        }
        if (fdf != null) {
            fdf.close();
        }
    }

    private void testContentStreamContains(PDDocument doc, PDField field, String expected) throws Exception {
        PDAnnotationWidget widget = field.getWidget();
        Map normalAppearance = widget.getAppearance().getNormalAppearance();
        PDAppearanceStream appearanceStream = (PDAppearanceStream)normalAppearance.get("default");
        COSStream actual = appearanceStream.getStream();
        List actualTokens = this.getStreamTokens(doc, actual);
        TestFDF.assertTrue((boolean)actualTokens.contains(new COSString(expected)));
    }

    private void testContentStreams(PDDocument doc, PDField field, String expected) throws Exception {
        PDAnnotationWidget widget = field.getWidget();
        Map normalAppearance = widget.getAppearance().getNormalAppearance();
        PDAppearanceStream appearanceStream = (PDAppearanceStream)normalAppearance.get("default");
        COSStream actual = appearanceStream.getStream();
        List actualTokens = this.getStreamTokens(doc, actual);
        List expectedTokens = this.getStreamTokens(doc, expected);
        TestFDF.assertEquals((int)actualTokens.size(), (int)expectedTokens.size());
        for (int i = 0; i < actualTokens.size(); ++i) {
            Object actualToken = actualTokens.get(i);
            Object expectedToken = expectedTokens.get(i);
            TestFDF.assertEquals(actualToken, expectedToken);
        }
    }

    private List getStreamTokens(PDDocument doc, String string) throws IOException {
        List tokens = null;
        if (string != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes());
            PDFStreamParser parser = new PDFStreamParser(stream, doc.getDocument().getScratchFile());
            parser.parse();
            tokens = parser.getTokens();
        }
        return tokens;
    }

    private List getStreamTokens(PDDocument doc, COSStream stream) throws IOException {
        List tokens = null;
        if (stream != null) {
            PDFStreamParser parser = new PDFStreamParser(stream);
            parser.parse();
            tokens = parser.getTokens();
        }
        return tokens;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

