/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.util.CDataEndEscapeFilterWriter;

public class PartialResponseWriterImpl
extends PartialResponseWriter {
    ResponseWriter _cdataDoubleBufferWriter = null;
    Writer _doubleBuffer = null;
    List<StackEntry> _nestingStack = new ArrayList<StackEntry>(4);

    public PartialResponseWriterImpl(ResponseWriter writer) {
        super(writer);
    }

    public void startCDATA() throws IOException {
        if (!this.isDoubleBufferEnabled()) {
            super.startCDATA();
        } else {
            this._cdataDoubleBufferWriter.write("<![CDATA[");
        }
        this.openDoubleBuffer();
    }

    private void openDoubleBuffer() {
        this._doubleBuffer = new CDataEndEscapeFilterWriter((Writer)(this._cdataDoubleBufferWriter == null ? this.getWrapped() : this._cdataDoubleBufferWriter));
        this._cdataDoubleBufferWriter = this.getWrapped().cloneWithWriter(this._doubleBuffer);
        StackEntry entry = new StackEntry(this._cdataDoubleBufferWriter, this._doubleBuffer);
        this._nestingStack.add(0, entry);
    }

    public void endCDATA() throws IOException {
        this.closeDoubleBuffer(false);
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.write("]]>");
        } else {
            super.endCDATA();
        }
    }

    private void closeDoubleBuffer(boolean force) throws IOException {
        if (!this.isDoubleBufferEnabled()) {
            return;
        }
        if (force) {
            while (!this._nestingStack.isEmpty()) {
                this.popAndEncodeCurrentStackEntry();
            }
        } else {
            this.popAndEncodeCurrentStackEntry();
        }
    }

    private void popAndEncodeCurrentStackEntry() throws IOException {
        StackEntry parent;
        StackEntry elem = this._nestingStack.remove(0);
        StackEntry stackEntry = parent = this._nestingStack.isEmpty() ? null : this._nestingStack.get(0);
        if (parent != null) {
            this._cdataDoubleBufferWriter = parent.getWriter();
            this._doubleBuffer = parent.getDoubleBuffer();
        } else {
            this._cdataDoubleBufferWriter = null;
            this._doubleBuffer = null;
        }
    }

    public void endInsert() throws IOException {
        this.closeDoubleBuffer(true);
        super.endInsert();
    }

    public void endUpdate() throws IOException {
        this.closeDoubleBuffer(true);
        super.endUpdate();
    }

    public void endExtension() throws IOException {
        this.closeDoubleBuffer(true);
        super.endExtension();
    }

    public void endEval() throws IOException {
        this.closeDoubleBuffer(true);
        super.endEval();
    }

    public void endError() throws IOException {
        this.closeDoubleBuffer(true);
        super.endError();
    }

    public void endElement(String name) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.endElement(name);
        } else {
            super.endElement(name);
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.writeComment(comment);
        } else {
            super.writeComment(comment);
        }
    }

    private boolean isDoubleBufferEnabled() {
        return !this._nestingStack.isEmpty();
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.startElement(name, component);
        } else {
            super.startElement(name, component);
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.writeText(text, property);
        } else {
            super.writeText(text, property);
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.writeText(text, off, len);
        } else {
            super.writeText(text, off, len);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.write(cbuf, off, len);
        } else {
            super.write(cbuf, off, len);
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return super.cloneWithWriter(writer);
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.writeURIAttribute(name, value, property);
        } else {
            super.writeURIAttribute(name, value, property);
        }
    }

    public void close() throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this.closeDoubleBuffer(true);
            super.endCDATA();
        }
        super.close();
    }

    public void flush() throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.flush();
        }
        super.flush();
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.writeAttribute(name, value, property);
        } else {
            super.writeAttribute(name, value, property);
        }
    }

    public void writeText(Object object, UIComponent component, String string) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.writeText(object, component, string);
        } else {
            super.writeText(object, component, string);
        }
    }

    public Writer append(char c) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.append(c);
            return this;
        }
        return super.append(c);
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.append(csq, start, end);
            return this;
        }
        return super.append(csq, start, end);
    }

    public Writer append(CharSequence csq) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.append(csq);
            return this;
        }
        return super.append(csq);
    }

    public void write(char[] cbuf) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.write(cbuf);
        } else {
            super.write(cbuf);
        }
    }

    public void write(int c) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.write(c);
        } else {
            super.write(c);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.write(str, off, len);
        } else {
            super.write(str, off, len);
        }
    }

    public void write(String str) throws IOException {
        if (this.isDoubleBufferEnabled()) {
            this._cdataDoubleBufferWriter.write(str);
        } else {
            super.write(str);
        }
    }

    class StackEntry {
        ResponseWriter writer;
        Writer _doubleBuffer;

        StackEntry(ResponseWriter writer, Writer doubleBuffer) {
            this.writer = writer;
            this._doubleBuffer = doubleBuffer;
        }

        public ResponseWriter getWriter() {
            return this.writer;
        }

        public void setWriter(ResponseWriter writer) {
            this.writer = writer;
        }

        public Writer getDoubleBuffer() {
            return this._doubleBuffer;
        }

        public void setDoubleBuffer(Writer doubleBuffer) {
            this._doubleBuffer = doubleBuffer;
        }
    }
}

