/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.myfaces.cdi.JsfApplicationArtifactHolder;
import org.apache.myfaces.cdi.view.ViewScopeContext;
import org.apache.myfaces.cdi.view.ViewScopeContextualStorage;
import org.apache.myfaces.context.ExceptionHandlerImpl;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;

@SessionScoped
public class ViewScopeBeanHolder
implements Serializable {
    private Map<String, ViewScopeContextualStorage> storageMap;
    private static final Random RANDOM_GENERATOR = new Random();
    public static final String CREATED = ViewScopeBeanHolder.class.getName() + ".CREATED";
    @Inject
    JsfApplicationArtifactHolder applicationContextBean;

    @PostConstruct
    public void init() {
        this.storageMap = new ConcurrentHashMap<String, ViewScopeContextualStorage>();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getExternalContext().getSessionMap().put(CREATED, true);
    }

    public ViewScopeContextualStorage getContextualStorage(BeanManager beanManager, String viewScopeId) {
        ViewScopeContextualStorage storage = this.storageMap.get(viewScopeId);
        if (storage == null) {
            storage = new ViewScopeContextualStorage(beanManager);
            this.storageMap.put(viewScopeId, storage);
        }
        return storage;
    }

    public Map<String, ViewScopeContextualStorage> getStorageMap() {
        return this.storageMap;
    }

    public Map<String, ViewScopeContextualStorage> forceNewStorage() {
        Map<String, ViewScopeContextualStorage> oldStorageMap = this.storageMap;
        this.storageMap = new ConcurrentHashMap<String, ViewScopeContextualStorage>();
        return oldStorageMap;
    }

    public void destroyBeans() {
        Map<String, ViewScopeContextualStorage> oldContextStorages = this.forceNewStorage();
        for (ViewScopeContextualStorage contextualStorage : oldContextStorages.values()) {
            ViewScopeContext.destroyAllActive(contextualStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyBeans(String viewScopeId) {
        block8: {
            ViewScopeContextualStorage contextualStorage = this.storageMap.get(viewScopeId);
            if (contextualStorage != null) {
                try {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    if (facesContext == null && this.applicationContextBean.getServletContext() != null) {
                        try {
                            ServletContext servletContext = this.applicationContextBean.getServletContext();
                            StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, false);
                            ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
                            facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ExternalContext)externalContext, exceptionHandler, false);
                            ViewScopeContext.destroyAllActive(contextualStorage, facesContext);
                            break block8;
                        }
                        finally {
                            facesContext.release();
                        }
                    }
                    ViewScopeContext.destroyAllActive(contextualStorage, facesContext);
                }
                finally {
                    this.storageMap.remove(viewScopeId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void destroyBeansOnPreDestroy() {
        Map<String, ViewScopeContextualStorage> oldContextStorages = this.forceNewStorage();
        if (!oldContextStorages.isEmpty()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null && this.applicationContextBean.getServletContext() != null) {
                try {
                    ServletContext servletContext = this.applicationContextBean.getServletContext();
                    StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, false);
                    ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
                    facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ExternalContext)externalContext, exceptionHandler, false);
                    for (ViewScopeContextualStorage contextualStorage : oldContextStorages.values()) {
                        ViewScopeContext.destroyAllActive(contextualStorage, facesContext);
                    }
                }
                finally {
                    facesContext.release();
                }
            } else {
                for (ViewScopeContextualStorage contextualStorage : oldContextStorages.values()) {
                    ViewScopeContext.destroyAllActive(contextualStorage);
                }
            }
        }
    }

    public String generateUniqueViewScopeId() {
        String key;
        while (this.storageMap.containsKey(key = Integer.toString(RANDOM_GENERATOR.nextInt()))) {
        }
        return key;
    }

    public void removeStorage(String viewScopeId) {
        this.storageMap.remove(viewScopeId);
    }
}

