/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.flow.cdi.FlowScopeContextualStorageHolder;

public class FlowScopeMap
implements Map {
    private BeanManager beanManager;
    private String currentClientWindowFlowId;
    private FlowScopeContextualStorageHolder storageHolder;
    private boolean beanHolderInitialized = false;

    public FlowScopeMap(BeanManager beanManager, String currentClientWindowFlowId) {
        this.beanManager = beanManager;
        this.currentClientWindowFlowId = currentClientWindowFlowId;
    }

    private Map<Object, Object> getWrapped(boolean create) {
        if (this.storageHolder == null) {
            if (create) {
                this.storageHolder = CDIUtils.get(this.beanManager, FlowScopeContextualStorageHolder.class);
            } else if (!this.beanHolderInitialized) {
                this.storageHolder = CDIUtils.get(this.beanManager, FlowScopeContextualStorageHolder.class, false, new Annotation[0]);
                this.beanHolderInitialized = true;
            }
        }
        if (this.storageHolder == null) {
            return null;
        }
        return this.storageHolder.getFlowScopeMap(this.beanManager, this.currentClientWindowFlowId, create);
    }

    @Override
    public int size() {
        Map<Object, Object> wrapped = this.getWrapped(false);
        return wrapped == null ? 0 : wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        Map<Object, Object> wrapped = this.getWrapped(false);
        return wrapped == null ? true : wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Map<Object, Object> wrapped = this.getWrapped(false);
        return wrapped == null ? false : wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Map<Object, Object> wrapped = this.getWrapped(false);
        return wrapped == null ? false : wrapped.containsValue(value);
    }

    public Object get(Object key) {
        Map<Object, Object> wrapped = this.getWrapped(false);
        return wrapped == null ? null : wrapped.get(key);
    }

    public Object put(Object key, Object value) {
        Map<Object, Object> wrapped = this.getWrapped(true);
        return wrapped.put(key, value);
    }

    public Object remove(Object key) {
        Map<Object, Object> wrapped = this.getWrapped(false);
        return wrapped == null ? null : wrapped.remove(key);
    }

    public void putAll(Map m) {
        Map<Object, Object> wrapped = this.getWrapped(true);
        wrapped.putAll(m);
    }

    @Override
    public void clear() {
        Map<Object, Object> wrapped = this.getWrapped(false);
        if (wrapped == null) {
            return;
        }
        wrapped.clear();
    }

    public Set keySet() {
        Map<Object, Object> wrapped = this.getWrapped(false);
        return wrapped == null ? Collections.emptySet() : wrapped.keySet();
    }

    public Collection values() {
        Map<Object, Object> wrapped = this.getWrapped(false);
        return wrapped == null ? Collections.emptyList() : wrapped.values();
    }

    public Set entrySet() {
        Map<Object, Object> wrapped = this.getWrapped(false);
        return wrapped == null ? Collections.emptySet() : wrapped.entrySet();
    }
}

