/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.trinidad.impl;

import java.util.logging.Level;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.apache.myfaces.extensions.cdi.core.api.startup.event.StartupEvent;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.AbstractStartupObserver;

@ApplicationScoped
public class TrinidadSupportModuleStartupObserver
extends AbstractStartupObserver {
    protected TrinidadSupportModuleStartupObserver() {
    }

    protected void logTrinidadSupportModuleConfiguration(@Observes StartupEvent startupEvent) {
        if (!this.codiCoreConfig.isConfigurationLoggingEnabled()) {
            return;
        }
        try {
            String moduleVersion = this.detectModuleVersion();
            StringBuilder info = new StringBuilder("[Started] MyFaces CODI ");
            info.append(this.getModuleName());
            info.append(moduleVersion);
            info.append(this.separator);
            this.logger.info(info.toString());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Trinidad-Support-Module couldn't log the current configuration.Startup will continue!", e);
        }
    }

    protected String detectModuleVersion() {
        String version = ClassUtils.getJarVersion(((Object)((Object)this)).getClass());
        if (version != null && !version.startsWith("null")) {
            return " v" + version;
        }
        return "";
    }

    protected String getModuleName() {
        return "Trinidad-Support-Module";
    }
}

