/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.bv.resolver;

import java.io.Serializable;
import java.util.Map;
import javax.enterprise.inject.Typed;
import javax.faces.context.FacesContext;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
class SerializableValidatorFactory
implements ValidatorFactory,
Serializable {
    private static final long serialVersionUID = 58677422630598169L;
    private static final String VALIDATOR_FACTORY_KEY = "javax.faces.validator.beanValidator.ValidatorFactory";
    private transient ValidatorFactory standaloneValidatorFactory;
    private transient ValidatorFactory currentValidatorFactory;
    private transient boolean jsfInitialized = false;

    public Validator getValidator() {
        return this.getValidatorFactory().getValidator();
    }

    public ValidatorContext usingContext() {
        return this.getValidatorFactory().usingContext();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.getValidatorFactory().getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.getValidatorFactory().getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.getValidatorFactory().getConstraintValidatorFactory();
    }

    public <T> T unwrap(Class<T> tClass) {
        return (T)this.getValidatorFactory().unwrap(tClass);
    }

    protected ValidatorFactory getValidatorFactory() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!this.jsfInitialized && facesContext == null && this.currentValidatorFactory == null) {
            return this.getStandaloneValidatorFactory();
        }
        if (facesContext == null) {
            return this.standaloneValidatorFactory;
        }
        if (this.jsfInitialized) {
            return this.currentValidatorFactory;
        }
        this.jsfInitialized = true;
        return this.getJsfAwareValidatorFactory(facesContext);
    }

    private ValidatorFactory getStandaloneValidatorFactory() {
        if (this.standaloneValidatorFactory == null) {
            this.standaloneValidatorFactory = Validation.buildDefaultValidatorFactory();
        }
        return this.standaloneValidatorFactory;
    }

    private ValidatorFactory getJsfAwareValidatorFactory(FacesContext facesContext) {
        if (this.currentValidatorFactory == null) {
            Map applicationMap = facesContext.getExternalContext().getApplicationMap();
            if (applicationMap.containsKey(VALIDATOR_FACTORY_KEY) && applicationMap.get(VALIDATOR_FACTORY_KEY) instanceof ValidatorFactory) {
                this.currentValidatorFactory = (ValidatorFactory)applicationMap.get(VALIDATOR_FACTORY_KEY);
            }
            if (this.currentValidatorFactory == null) {
                this.currentValidatorFactory = this.getStandaloneValidatorFactory();
                applicationMap.put(VALIDATOR_FACTORY_KEY, this.currentValidatorFactory);
            }
        }
        return this.currentValidatorFactory;
    }
}

