/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.listener.phase;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.validator.Validator;
import org.apache.myfaces.extensions.cdi.core.api.config.CodiCoreConfig;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.BeforePhase;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.JsfPhaseId;
import org.apache.myfaces.extensions.cdi.jsf.api.request.RequestTypeResolver;

@ApplicationScoped
public class RestoreInjectionPointsObserver {
    private String injectionMarker = RestoreInjectionPointsObserver.class.getName() + ":injected";

    protected void restoreInjectionPoints(@Observes @BeforePhase(value=JsfPhaseId.PROCESS_VALIDATIONS) PhaseEvent event, CodiCoreConfig codiCoreConfig) {
        FacesContext facesContext = event.getFacesContext();
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        this.restoreAllInjectionPoints(uiViewRoot, codiCoreConfig);
        facesContext.getExternalContext().getRequestMap().put(this.injectionMarker, uiViewRoot.getViewId());
    }

    protected void restoreInjectionPointsForSkippedRequests(@Observes @BeforePhase(value=JsfPhaseId.RENDER_RESPONSE) PhaseEvent event, CodiCoreConfig codiCoreConfig, RequestTypeResolver requestTypeResolver) {
        if (!requestTypeResolver.isPostRequest()) {
            return;
        }
        FacesContext facesContext = event.getFacesContext();
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (this.isSkippedPostback(facesContext)) {
            this.restoreAllInjectionPoints(uiViewRoot, codiCoreConfig);
        }
    }

    private boolean isSkippedPostback(FacesContext facesContext) {
        Object storedViewId = facesContext.getExternalContext().getRequestMap().get(this.injectionMarker);
        return storedViewId == null;
    }

    private void restoreAllInjectionPoints(UIViewRoot uiViewRoot, CodiCoreConfig codiCoreConfig) {
        if (uiViewRoot == null) {
            return;
        }
        boolean advancedQualifierRequiredForDependencyInjection = codiCoreConfig.isAdvancedQualifierRequiredForDependencyInjection();
        this.processComponents((UIComponent)uiViewRoot, advancedQualifierRequiredForDependencyInjection);
    }

    private void processComponents(UIComponent uiComponent, boolean advancedQualifierRequiredForDependencyInjection) {
        int childCount;
        if (uiComponent == null) {
            return;
        }
        if (uiComponent.getFacetCount() > 0) {
            for (UIComponent facet : uiComponent.getFacets().values()) {
                this.inject(facet, advancedQualifierRequiredForDependencyInjection);
                this.processComponents(facet, advancedQualifierRequiredForDependencyInjection);
            }
        }
        if ((childCount = uiComponent.getChildCount()) > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)uiComponent.getChildren().get(i);
                this.inject(child, advancedQualifierRequiredForDependencyInjection);
                this.processComponents(child, advancedQualifierRequiredForDependencyInjection);
            }
        }
    }

    private void inject(UIComponent uiComponent, boolean advancedQualifierRequiredForDependencyInjection) {
        if (uiComponent instanceof ValueHolder) {
            CodiUtils.injectFields((Object)((ValueHolder)uiComponent).getConverter());
            if (uiComponent instanceof EditableValueHolder) {
                for (Validator validator : ((EditableValueHolder)uiComponent).getValidators()) {
                    CodiUtils.injectFields((Object)validator, (boolean)advancedQualifierRequiredForDependencyInjection);
                }
            }
        }
    }
}

