/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.message;

import java.util.List;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.impl.projectstage.ProjectStageProducer;
import org.apache.myfaces.extensions.cdi.message.api.AbstractMessageHandler;
import org.apache.myfaces.extensions.cdi.message.api.Message;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.MessageWithSeverity;
import org.apache.myfaces.extensions.cdi.message.api.payload.MessagePayload;
import org.apache.myfaces.extensions.cdi.message.api.payload.MessageSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsfAwareMessageHandler
extends AbstractMessageHandler {
    private static final long serialVersionUID = -7193428173462936712L;
    private transient Logger logger;
    private boolean projectStageDevelopment;

    JsfAwareMessageHandler() {
    }

    protected void processMessage(MessageContext messageContext, Message message) {
        FacesContext facesContext;
        MessageSeverity.Info severity = MessageSeverity.INFO;
        if (message instanceof MessageWithSeverity) {
            severity = ((MessageWithSeverity)message).getSeverity();
        }
        if ((facesContext = FacesContext.getCurrentInstance()) != null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(this.convertSeverity((MessagePayload)severity), message.toString(messageContext), message.toString(messageContext)));
        } else {
            this.logMessage(message.toString(messageContext), (MessagePayload)severity);
        }
    }

    private void logMessage(String messageText, MessagePayload severity) {
        if (this.logger == null) {
            this.logger = Logger.getLogger(JsfAwareMessageHandler.class.getName());
            boolean bl = this.projectStageDevelopment = ProjectStage.Development == ProjectStageProducer.getInstance().getProjectStage();
        }
        if (this.projectStageDevelopment) {
            this.logger.warning(((Object)((Object)this)).getClass().getName() + " logs a message instead of using the " + FacesContext.class.getName());
        }
        if (MessageSeverity.INFO.equals((Object)severity)) {
            this.logger.info(messageText);
        } else if (MessageSeverity.WARN.equals((Object)severity)) {
            this.logger.warning(messageText);
        } else {
            this.logger.severe(messageText);
        }
    }

    private FacesMessage.Severity convertSeverity(MessagePayload payload) {
        if (MessageSeverity.INFO.equals((Object)payload)) {
            return FacesMessage.SEVERITY_INFO;
        }
        if (MessageSeverity.WARN.equals((Object)payload)) {
            return FacesMessage.SEVERITY_WARN;
        }
        if (MessageSeverity.ERROR.equals((Object)payload)) {
            return FacesMessage.SEVERITY_ERROR;
        }
        if (MessageSeverity.FATAL.equals((Object)payload)) {
            return FacesMessage.SEVERITY_FATAL;
        }
        throw new IllegalArgumentException(payload.getClass().getName());
    }

    public void removeMessage(Message message) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void removeAllMessages() {
        throw new UnsupportedOperationException("not implemented");
    }

    public List<Message> getMessages() {
        throw new UnsupportedOperationException("not implemented");
    }
}

