/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowScoped;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.ViewAccessConversationExpirationEvaluator;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContext;

@WindowScoped
public class ViewAccessConversationExpirationEvaluatorRegistry
implements Serializable {
    private static final long serialVersionUID = -1783266839383634211L;
    @Inject
    private EditableWindowContext windowContext;
    private CopyOnWriteArrayList<ViewAccessConversationExpirationEvaluator> viewAccessConversationExpirationEvaluatorList = new CopyOnWriteArrayList();

    protected ViewAccessConversationExpirationEvaluatorRegistry() {
    }

    void addViewAccessConversationExpirationEvaluator(ViewAccessConversationExpirationEvaluator evaluator) {
        this.viewAccessConversationExpirationEvaluatorList.add(evaluator);
    }

    public void broadcastRenderedViewId(String viewId) {
        for (ViewAccessConversationExpirationEvaluator evaluator : this.viewAccessConversationExpirationEvaluatorList) {
            evaluator.observeRenderedView(viewId);
            if (!evaluator.isExpired()) continue;
            this.viewAccessConversationExpirationEvaluatorList.remove(evaluator);
        }
    }

    @PreDestroy
    protected void save() {
        if (FacesContext.getCurrentInstance() == null || !this.windowContext.isActive()) {
            return;
        }
        this.windowContext.setAttribute(ViewAccessConversationExpirationEvaluatorRegistry.class.getName(), this.viewAccessConversationExpirationEvaluatorList, true);
    }

    @PostConstruct
    protected void restore() {
        if (FacesContext.getCurrentInstance() == null || !this.windowContext.isActive()) {
            return;
        }
        CopyOnWriteArrayList restoredList = (CopyOnWriteArrayList)this.windowContext.getAttribute(ViewAccessConversationExpirationEvaluatorRegistry.class.getName(), CopyOnWriteArrayList.class);
        if (restoredList != null) {
            this.viewAccessConversationExpirationEvaluatorList = restoredList;
        }
    }
}

