/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.security;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionVoterContext;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDeniedException;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.SecurityUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.AfterPhase;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.BeforePhase;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.JsfPhaseId;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewConfigCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.EditableViewConfigDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityViewListener {
    private static final String LAZY_SECURITY_CHECK_KEY = "LAZY_SECURITY_CHECK";

    public void checkPermission(@Observes @AfterPhase(value=JsfPhaseId.RESTORE_VIEW) PhaseEvent event, BeanManager beanManager) {
        FacesContext facesContext = event.getFacesContext();
        if (facesContext.getViewRoot() == null) {
            this.triggerFallback(facesContext);
            return;
        }
        this.checkPermission(beanManager, facesContext);
    }

    public void checkPermissionBeforeRendering(@Observes @BeforePhase(value=JsfPhaseId.RENDER_RESPONSE) PhaseEvent event, BeanManager beanManager) {
        FacesContext facesContext = event.getFacesContext();
        if (facesContext.getViewRoot() == null) {
            return;
        }
        Map<String, Object> requestMap = this.getRequestMap(facesContext);
        if (requestMap != null && Boolean.TRUE.equals(requestMap.get(LAZY_SECURITY_CHECK_KEY))) {
            this.checkPermission(beanManager, facesContext);
        }
    }

    private void checkPermission(BeanManager beanManager, FacesContext facesContext) {
        ViewConfigDescriptor entry = ViewConfigCache.getViewConfigDescriptor(facesContext.getViewRoot().getViewId());
        if (entry == null) {
            return;
        }
        try {
            Class<? extends ViewConfig> errorView = null;
            AccessDecisionVoterContext voterContext = (AccessDecisionVoterContext)CodiUtils.getContextualReferenceByClass((BeanManager)beanManager, AccessDecisionVoterContext.class, (boolean)true, (Annotation[])new Annotation[0]);
            if (entry instanceof EditableViewConfigDescriptor) {
                errorView = ((EditableViewConfigDescriptor)entry).getErrorView();
            }
            SecurityUtils.invokeVoters(null, (BeanManager)beanManager, (AccessDecisionVoterContext)voterContext, (List)entry.getAccessDecisionVoters(), errorView);
        }
        catch (AccessDeniedException accessDeniedException) {
            org.apache.myfaces.extensions.cdi.jsf.impl.util.SecurityUtils.tryToHandleSecurityViolation((RuntimeException)((Object)accessDeniedException));
            facesContext.renderResponse();
        }
    }

    private void triggerFallback(FacesContext facesContext) {
        Map<String, Object> requestMap = this.getRequestMap(facesContext);
        if (requestMap != null) {
            requestMap.put(LAZY_SECURITY_CHECK_KEY, Boolean.TRUE);
        }
    }

    private Map<String, Object> getRequestMap(FacesContext facesContext) {
        if (facesContext.getExternalContext() == null || facesContext.getExternalContext().getRequestMap() == null) {
            return null;
        }
        return facesContext.getExternalContext().getRequestMap();
    }
}

