/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jpa.impl.datasource;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.impl.util.JndiUtils;
import org.apache.myfaces.extensions.cdi.jpa.api.datasource.DataSourceConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableDataSource
implements DataSource {
    private volatile boolean loaded = false;
    private String connectionId = "default";
    private DataSourceConfig dataSourceConfig = (DataSourceConfig)BeanManagerProvider.getInstance().getContextualReference(DataSourceConfig.class, new Annotation[0]);
    private String jdbcConnectionURL;
    private Properties connectionProperties;
    private DataSource wrappedDataSource = null;
    private Driver wrappedJdbcDriver = null;

    public void setConnectionId(String connectionId) {
        if (this.loaded) {
            throw new IllegalStateException("connectionId must not get changed after the DataSource was established");
        }
        this.connectionId = connectionId;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        if (!this.loaded) {
            this.initDataSource();
        }
        if (this.wrappedDataSource != null) {
            if (userName == null && password == null) {
                return this.wrappedDataSource.getConnection();
            }
            return this.wrappedDataSource.getConnection(userName, password);
        }
        if (this.wrappedJdbcDriver != null) {
            return this.wrappedJdbcDriver.connect(this.jdbcConnectionURL, this.connectionProperties);
        }
        return null;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(ConfigurableDataSource.class);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    protected synchronized void initDataSource() throws SQLException {
        block11: {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            String jndiLookupName = this.dataSourceConfig.getJndiResourceName(this.connectionId);
            if (jndiLookupName != null && jndiLookupName.length() > 0) {
                this.wrappedDataSource = (DataSource)JndiUtils.lookup((String)jndiLookupName, DataSource.class);
                return;
            }
            String dataSourceClass = this.dataSourceConfig.getConnectionClassName(this.connectionId);
            if (dataSourceClass == null || dataSourceClass.length() == 0) {
                throw new SQLException("Neither a JNDI location nor a JDBC driver class name is configured!");
            }
            this.connectionProperties = this.dataSourceConfig.getConnectionProperties(this.connectionId);
            try {
                Class<?> clazz = Class.forName(dataSourceClass);
                if (DataSource.class.isAssignableFrom(clazz)) {
                    this.wrappedDataSource = (DataSource)clazz.newInstance();
                    for (Map.Entry<Object, Object> configOption : this.connectionProperties.entrySet()) {
                        String name = (String)configOption.getKey();
                        String value = (String)configOption.getValue();
                        this.setProperty(this.wrappedDataSource, name, value);
                    }
                    break block11;
                }
                if (Driver.class.isAssignableFrom(clazz)) {
                    this.jdbcConnectionURL = this.dataSourceConfig.getJdbcConnectionUrl(this.connectionId);
                    if (this.jdbcConnectionURL == null) {
                        throw new SQLException("Neither a JNDI location nor a JDBC connection URL is configured!");
                    }
                    this.wrappedJdbcDriver = (Driver)clazz.newInstance();
                    break block11;
                }
                throw new SQLException("Configured DriverClassName is not a javax.sql.DataSource nor a javax.sql.Driver: " + dataSourceClass);
            }
            catch (RuntimeException e) {
                this.wrappedDataSource = null;
                throw e;
            }
            catch (SQLException e) {
                this.wrappedDataSource = null;
                throw e;
            }
            catch (Exception e) {
                this.wrappedDataSource = null;
                throw new RuntimeException(e);
            }
        }
    }

    protected void setProperty(Object instance, String key, String value) throws InvocationTargetException, IllegalAccessException {
        if (key.length() == 0) {
            throw new IllegalArgumentException("property name must not be empty!");
        }
        String setterName = "set" + Character.toUpperCase(key.charAt(0)) + key.substring(1);
        AccessibleObject setter = null;
        try {
            setter = instance.getClass().getMethod(setterName, String.class);
        }
        catch (NoSuchMethodException e) {
            try {
                setter = instance.getClass().getMethod(setterName, Object.class);
            }
            catch (NoSuchMethodException e1) {
                // empty catch block
            }
        }
        if (setter == null) {
            return;
        }
        if (!setter.isAccessible()) {
            ((Method)setter).setAccessible(true);
        }
        ((Method)setter).invoke(instance, value);
    }
}

