/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.storage.GroupStorage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.GroupUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultGroupStorage
implements GroupStorage {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, List<Class>> addedGroups = new HashMap<String, List<Class>>();
    private Map<String, List<Class>> restrictedGroups = new HashMap<String, List<Class>>();

    @Override
    public void addGroup(Class groupClass, String viewId, String clientId) {
        this.addGroupToGroupStorage(groupClass, viewId, clientId, this.addedGroups);
    }

    @Override
    public void restrictGroup(Class groupClass, String viewId, String clientId) {
        this.addGroupToGroupStorage(groupClass, viewId, clientId, this.restrictedGroups);
    }

    @Override
    public Class[] getGroups(String viewId, String clientId) {
        if (this.addedGroups.size() < 1) {
            return null;
        }
        String key = GroupUtils.getGroupKey(viewId, null);
        List<Class> resultListForPage = this.buildGroupList(key, this.addedGroups);
        key = GroupUtils.getGroupKey(viewId, clientId);
        List<Class> resultListForComponent = this.buildGroupList(key, this.addedGroups);
        Class[] resultsForPage = this.filterGroupList(GroupUtils.getGroupKey(viewId, null), resultListForPage);
        Class[] resultsForComponent = this.filterGroupList(GroupUtils.getGroupKey(viewId, clientId), resultListForComponent);
        if (resultsForPage.length == 0) {
            if (resultsForComponent.length == 0) {
                this.logger.fine("no groups for group-validation available.maybe you restricted all groups or you aren't using groups.bean validation will use the default group for validation");
            }
            return resultsForComponent;
        }
        if (resultsForComponent.length == 0) {
            return resultsForPage;
        }
        return this.mergeResults(resultsForPage, resultsForComponent);
    }

    private void addGroupToGroupStorage(Class groupClass, String viewId, String clientId, Map<String, List<Class>> groupStorage) {
        List<Class> groupList = groupStorage.get(GroupUtils.getGroupKey(viewId, clientId));
        if (groupList == null) {
            groupList = new ArrayList<Class>();
            groupStorage.put(GroupUtils.getGroupKey(viewId, clientId), groupList);
        }
        if (!groupList.contains(groupClass)) {
            groupList.add(groupClass);
        }
    }

    private List<Class> buildGroupList(String key, Map<String, List<Class>> groupStorage) {
        ArrayList list = groupStorage.get(key);
        return list != null ? list : new ArrayList();
    }

    private Class[] filterGroupList(String key, List<Class> addedGroups) {
        List<Class> restrictedGroups = this.buildGroupList(key, this.restrictedGroups);
        ArrayList<Class> results = new ArrayList<Class>();
        for (Class currentGroup : addedGroups) {
            if (restrictedGroups.contains(currentGroup)) continue;
            results.add(currentGroup);
        }
        return results.toArray(new Class[results.size()]);
    }

    private Class[] mergeResults(Class[] resultsForPage, Class[] resultsForComponent) {
        Class[] mergedResult = new Class[resultsForPage.length + resultsForComponent.length];
        System.arraycopy(resultsForPage, 0, mergedResult, 0, resultsForPage.length);
        System.arraycopy(resultsForComponent, 0, mergedResult, resultsForPage.length, resultsForComponent.length);
        return mergedResult;
    }
}

