/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval;

import java.lang.reflect.Method;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.extensions.validator.PropertyValidationModuleKey;
import org.apache.myfaces.extensions.validator.crossval.ExtValCrossValidationModuleConfiguration;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.strategy.AbstractCrossValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.CrossValidationUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.JsfUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class CrossValidationPhaseListener
implements PhaseListener {
    private boolean isInitialized = false;
    private static final long serialVersionUID = -5333405897635742732L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPhase(PhaseEvent event) {
        try {
            CrossValidationStorage crossValidationStorage = CrossValidationUtils.getOrInitCrossValidationStorage();
            FacesContext facesContext = FacesContext.getCurrentInstance();
            for (CrossValidationStorageEntry entry : crossValidationStorage.getCrossValidationStorageEntries()) {
                try {
                    if (!ExtValUtils.executeGlobalBeforeValidationInterceptors((FacesContext)facesContext, (UIComponent)entry.getComponent(), (Object)entry.getConvertedObject(), (String)CrossValidationStorageEntry.class.getName(), (Object)entry, PropertyValidationModuleKey.class)) continue;
                    if (entry.getValidationStrategy() instanceof AbstractCrossValidationStrategy) {
                        ReflectionUtils.tryToInvokeMethod((Object)entry.getValidationStrategy(), (Method)ReflectionUtils.tryToGetMethod((Class)ProxyUtils.getUnproxiedClass(entry.getValidationStrategy().getClass()), (String)"initCrossValidation", (Class[])new Class[]{CrossValidationStorageEntry.class}), (Object[])new Object[]{entry});
                    }
                    entry.getValidationStrategy().processCrossValidation(entry, crossValidationStorage);
                }
                catch (ValidatorException validatorException) {
                    boolean addMessage = true;
                    if (entry.getValidationStrategy() instanceof AbstractCrossValidationStrategy) {
                        try {
                            addMessage = (Boolean)ReflectionUtils.tryToInvokeMethod((Object)entry.getValidationStrategy(), (Method)ReflectionUtils.tryToGetMethod((Class)ProxyUtils.getUnproxiedClass(entry.getValidationStrategy().getClass()), (String)"processAfterCrossValidatorException", (Class[])new Class[]{CrossValidationStorageEntry.class, ((Object)((Object)validatorException)).getClass()}), (Object[])new Object[]{entry, validatorException});
                        }
                        catch (Exception e) {
                            throw new FacesException((Throwable)e);
                        }
                    }
                    if (!addMessage) continue;
                    FacesMessage facesMessage = validatorException.getFacesMessage();
                    if (facesMessage != null && facesMessage.getSummary() != null && facesMessage.getDetail() != null) {
                        ExtValUtils.tryToAddViolationMessageForComponentId((String)entry.getClientId(), (FacesMessage)facesMessage);
                    }
                    ExtValUtils.tryToBlocksNavigationForComponentId((String)entry.getClientId(), (FacesMessage)facesMessage);
                }
                finally {
                    ExtValUtils.executeGlobalAfterValidationInterceptors((FacesContext)facesContext, (UIComponent)entry.getComponent(), (Object)entry.getConvertedObject(), (String)CrossValidationStorageEntry.class.getName(), (Object)entry, PropertyValidationModuleKey.class);
                }
            }
        }
        finally {
            CrossValidationUtils.resetCrossValidationStorage();
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (!this.isInitialized) {
            if (ExtValCrossValidationModuleConfiguration.get().deactivateCrossvalidation()) {
                JsfUtils.deregisterPhaseListener((PhaseListener)this);
            } else {
                this.isInitialized = true;
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof CrossValidationPhaseListener;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

