/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.factory;

import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ApplicationWrapper;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.factory.ExtValAjaxBehavior;
import org.apache.myfaces.extensions.validator.core.factory.ExtValViewRoot;

class ExtValApplicationWrapper
extends ApplicationWrapper {
    private static final boolean DEACTIVATE_VIEW_ROOT_INTERCEPTOR = ExtValCoreConfiguration.get().deactivateViewRootInterceptor();
    private static final boolean DEACTIVATE_AJAX_ACTION_BASED_GROUP_VALIDATION = ExtValCoreConfiguration.get().deactivateAjaxActionBasedGroupValidation();
    private Application wrapped;

    ExtValApplicationWrapper(Application wrapped) {
        this.wrapped = wrapped;
    }

    public Application getWrapped() {
        return this.wrapped;
    }

    public void addDefaultValidatorId(String s) {
        if (!"javax.faces.Bean".equals(s)) {
            super.addDefaultValidatorId(s);
        }
    }

    public UIComponent createComponent(FacesContext context, Resource componentResource) {
        UIComponent result = super.createComponent(context, componentResource);
        return this.customizedComponent(result);
    }

    public UIComponent createComponent(FacesContext context, String componentType, String rendererType) {
        UIComponent result = super.createComponent(context, componentType, rendererType);
        return this.customizedComponent(result);
    }

    public UIComponent createComponent(String componentType) throws FacesException {
        UIComponent result = super.createComponent(componentType);
        return this.customizedComponent(result);
    }

    public UIComponent createComponent(ValueBinding componentBinding, FacesContext context, String componentType) throws FacesException {
        UIComponent result = super.createComponent(componentBinding, context, componentType);
        return this.customizedComponent(result);
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType, String rendererType) {
        UIComponent result = super.createComponent(componentExpression, context, componentType, rendererType);
        return this.customizedComponent(result);
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext contexte, String componentType) throws FacesException {
        UIComponent result = super.createComponent(componentExpression, contexte, componentType);
        return this.customizedComponent(result);
    }

    private UIComponent customizedComponent(UIComponent result) {
        if (DEACTIVATE_VIEW_ROOT_INTERCEPTOR) {
            return result;
        }
        if (result != null && result.getClass().getName().equals(UIViewRoot.class.getName())) {
            return new ExtValViewRoot();
        }
        return result;
    }

    public Behavior createBehavior(String behaviorId) throws FacesException {
        Behavior result = this.wrapped.createBehavior(behaviorId);
        if (DEACTIVATE_AJAX_ACTION_BASED_GROUP_VALIDATION) {
            return result;
        }
        if (result != null && result.getClass().equals(AjaxBehavior.class)) {
            return new ExtValAjaxBehavior();
        }
        return result;
    }
}

