/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.interceptor;

import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.component.html.HtmlSelectManyListbox;
import javax.faces.component.html.HtmlSelectManyMenu;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.extensions.validator.core.InvocationOrder;
import org.apache.myfaces.extensions.validator.core.interceptor.ValidationExceptionInterceptor;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.validation.exception.RequiredValidatorException;
import org.apache.myfaces.extensions.validator.core.validation.message.LabeledMessage;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

@InvocationOrder(value=100)
@UsageInformation(value={UsageCategory.INTERNAL})
public class HtmlCoreComponentsValidationExceptionInterceptor
implements ValidationExceptionInterceptor {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    public boolean afterThrowing(UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject, ValidatorException validatorException, ValidationStrategy validatorExceptionSource) {
        if (this.processComponent(uiComponent)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            FacesMessage facesMessage = ExtValUtils.convertFacesMessage(validatorException.getFacesMessage());
            this.tryToUseInlineMessage(uiComponent, validatorException);
            this.tryToUseLabel(facesContext, uiComponent, metaDataEntry, facesMessage);
            this.tryToBlocksNavigation(uiComponent, metaDataEntry, facesMessage);
        }
        return true;
    }

    private void tryToUseInlineMessage(UIComponent uiComponent, ValidatorException validatorException) {
        FacesMessage facesMessage = validatorException.getFacesMessage();
        if (validatorException instanceof RequiredValidatorException) {
            String inlineMessage = this.getInlineRequiredMessage(uiComponent);
            if (inlineMessage != null) {
                facesMessage.setSummary(inlineMessage);
                facesMessage.setDetail(inlineMessage);
            }
        } else {
            String inlineMessage = this.getInlineValidatorMessage(uiComponent);
            if (inlineMessage != null) {
                facesMessage.setSummary(inlineMessage);
                facesMessage.setDetail(inlineMessage);
            }
        }
    }

    private void tryToUseLabel(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, FacesMessage facesMessage) {
        String label = (String)ReflectionUtils.tryToInvokeMethod(uiComponent, ReflectionUtils.tryToGetMethod(uiComponent.getClass(), "getLabel"));
        if (label == null) {
            label = uiComponent.getClientId(facesContext);
        }
        if (metaDataEntry != null && metaDataEntry.getProperty("label") != null) {
            label = metaDataEntry.getProperty("label", String.class);
        }
        if (facesMessage instanceof LabeledMessage) {
            ((LabeledMessage)facesMessage).setLabelText(label);
        } else {
            for (int i = 0; i < 3; ++i) {
                ExtValUtils.tryToPlaceLabel(facesMessage, label, i);
            }
        }
    }

    @ToDo(value=Priority.MEDIUM, description="check if it is still required here")
    private void tryToBlocksNavigation(UIComponent uiComponent, MetaDataEntry metaDataEntry, FacesMessage facesMessage) {
        if (metaDataEntry != null && metaDataEntry.getValue() instanceof Annotation) {
            ExtValUtils.tryToBlocksNavigationForComponent(uiComponent, facesMessage);
        }
    }

    private String getInlineRequiredMessage(UIComponent uiComponent) {
        return (String)ReflectionUtils.tryToInvokeMethod(uiComponent, ReflectionUtils.tryToGetMethod(uiComponent.getClass(), "getRequiredMessage"));
    }

    private String getInlineValidatorMessage(UIComponent uiComponent) {
        return (String)ReflectionUtils.tryToInvokeMethod(uiComponent, ReflectionUtils.tryToGetMethod(uiComponent.getClass(), "getValidatorMessage"));
    }

    protected boolean processComponent(UIComponent uiComponent) {
        return uiComponent instanceof HtmlInputText || uiComponent instanceof HtmlInputSecret || uiComponent instanceof HtmlSelectBooleanCheckbox || uiComponent instanceof HtmlSelectOneListbox || uiComponent instanceof HtmlSelectOneMenu || uiComponent instanceof HtmlSelectOneRadio || uiComponent instanceof HtmlSelectManyCheckbox || uiComponent instanceof HtmlSelectManyListbox || uiComponent instanceof HtmlSelectManyMenu || uiComponent instanceof HtmlInputTextarea;
    }
}

