/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.tobago.compat.FacesUtilsEL;

public final class ComponentAttributeUtils {
    private ComponentAttributeUtils() {
    }

    public static void setBooleanProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (ComponentAttributeUtils.isValueReference(value)) {
                component.setValueExpression(name, FacesUtilsEL.createValueExpression(value));
            } else {
                component.getAttributes().put(name, Boolean.valueOf(value));
            }
        }
    }

    public static void setStringProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (ComponentAttributeUtils.isValueReference(value)) {
                component.setValueExpression(name, FacesUtilsEL.createValueExpression(value));
            } else {
                component.getAttributes().put(name, value);
            }
        }
    }

    public static boolean isValueReference(String value) {
        int start = value.indexOf("#{");
        if (start < 0) {
            return false;
        }
        int end = value.lastIndexOf(125);
        return end >= 0 && start < end;
    }

    @Deprecated
    public static ValueBinding createValueBinding(String value) {
        return FacesContext.getCurrentInstance().getApplication().createValueBinding(value);
    }
}

