/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.tobago.event.PageAction;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.renderkit.html.standard.standard.tag.LinkRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetPageCommandRenderer
extends LinkRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(SheetPageCommandRenderer.class);

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        String actionId = FacesContextUtils.getActionId((FacesContext)facesContext);
        String clientId = component.getClientId(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("actionId = '" + actionId + "'");
            LOG.debug("clientId = '" + clientId + "'");
        }
        if (actionId != null && actionId.equals(clientId)) {
            PageAction action;
            try {
                action = PageAction.parse((String)component.getId());
            }
            catch (Exception e) {
                LOG.error("Illegal value for PageAction :" + component.getId());
                return;
            }
            PageActionEvent event = new PageActionEvent(component.getParent(), action);
            switch (action) {
                case TO_PAGE: 
                case TO_ROW: {
                    Map map = facesContext.getExternalContext().getRequestParameterMap();
                    Object value = map.get(clientId + "::" + "value");
                    try {
                        event.setValue(Integer.parseInt((String)value));
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Can't parse integer value for action " + action.name() + ": " + value);
                    }
                    break;
                }
            }
            component.queueEvent((FacesEvent)event);
        }
    }
}

