// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIOut;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.OutTagDeclaration}.
 */
public final class OutTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(OutTag.class);
  private javax.el.ValueExpression  converter;
  private javax.el.ValueExpression  tip;
  private javax.el.ValueExpression  value;
  private javax.el.ValueExpression  escape;
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  sanitize;

  @Override
  public String getComponentType() {
    return UIOut.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Out";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIOut component = (UIOut) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (converter != null) {
      if (!converter.isLiteralText()) {
        component.setValueExpression("converter", converter);
      } else {
        component.setConverter(application.createConverter(converter.getExpressionString()));
      }
    }
    if (tip != null) {
      component.setValueExpression("tip", tip);
    }

    if (value != null) {
      component.setValueExpression("value", value);
    }

    if (escape != null) {
      if (!escape.isLiteralText()) {
        component.setValueExpression("escape", escape);
      } else {
        component.setEscape(Boolean.parseBoolean(escape.getExpressionString()));
      }
    }
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (sanitize != null) {
      component.setValueExpression("sanitize", sanitize);
    }

  }

  public javax.el.ValueExpression getConverter() {
    return converter;
  }

  public void setConverter(final javax.el.ValueExpression converter) {
    this.converter = converter;
  }

  public javax.el.ValueExpression getTip() {
    return tip;
  }

  public void setTip(final javax.el.ValueExpression tip) {
    this.tip = tip;
  }

  public javax.el.ValueExpression getValue() {
    return value;
  }

  public void setValue(final javax.el.ValueExpression value) {
    this.value = value;
  }

  public javax.el.ValueExpression getEscape() {
    return escape;
  }

  public void setEscape(final javax.el.ValueExpression escape) {
    this.escape = escape;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getSanitize() {
    return sanitize;
  }

  public void setSanitize(final javax.el.ValueExpression sanitize) {
    this.sanitize = sanitize;
  }



  @Override
  public void release() {
    super.release();
    converter = null;
    tip = null;
    value = null;
    escape = null;
    markup = null;
    sanitize = null;
  }
}