/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.css;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.layout.AlignItems;
import org.apache.myfaces.tobago.layout.JustifyContent;
import org.apache.myfaces.tobago.layout.Margin;
import org.apache.myfaces.tobago.layout.MarginTokens;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.MeasureList;
import org.apache.myfaces.tobago.layout.TextAlign;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BootstrapClass implements CssItem
{
    ACTIVE("active"),
    ALERT("alert"),
    ALERT_DANGER("alert-danger"),
    ALERT_WARNING("alert-warning"),
    ALERT_INFO("alert-info"),
    ALERT_DISMISSIBLE("alert-dismissible"),
    ALIGN_ITEMS_BASELINE("align-items-baseline"),
    ALIGN_ITEMS_CENTER("align-items-center"),
    ALIGN_ITEMS_END("align-items-end"),
    ALIGN_ITEMS_START("align-items-start"),
    ALIGN_ITEMS_STRETCH("align-items-stretch"),
    BG_DARK("bg-dark"),
    BG_INVERSE("bg-dark"),
    BADGE("badge"),
    BADGE_DANGER("badge-danger"),
    BADGE_DARK("badge-dark"),
    BADGE_DEFAULT("badge-default"),
    BADGE_INFO("badge-info"),
    BADGE_LIGHT("badge-light"),
    BADGE_PILL("badge-pill"),
    BADGE_PRIMARY("badge-primary"),
    BADGE_SECONDARY("badge-secondary"),
    BADGE_SUCCESS("badge-success"),
    BADGE_WARNING("badge-warning"),
    BORDER_DANGER("border-danger"),
    BORDER_INFO("border-info"),
    BORDER_WARNING("border-warning"),
    BTN("btn"),
    BTN_DANGER("btn-danger"),
    BTN_DARK("btn-dark"),
    BTN_GROUP("btn-group"),
    BTN_GROUP_VERTICAL("btn-group-vertical"),
    BTN_INFO("btn-info"),
    BTN_LIGHT("btn-light"),
    BTN_LINK("btn-link"),
    BTN_PRIMARY("btn-primary"),
    BTN_OUTLINE_DANGER("btn-outline-danger"),
    BTN_OUTLINE_DARK("btn-outline-dark"),
    BTN_OUTLINE_INFO("btn-outline-info"),
    BTN_OUTLINE_LIGHT("btn-outline-light"),
    BTN_OUTLINE_PRIMARY("btn-outline-primary"),
    BTN_OUTLINE_SECONDARY("btn-outline-secondary"),
    BTN_OUTLINE_SUCCESS("btn-outline-success"),
    BTN_OUTLINE_WARNING("btn-outline-warning"),
    BTN_SECONDARY("btn-secondary"),
    BTN_SUCCESS("btn-success"),
    BTN_TOOLBAR("btn-toolbar"),
    BTN_WARNING("btn-warning"),
    CARD("card"),
    CARD_BLOCK("card-body"),
    CARD_BODY("card-body"),
    CARD_HEADER("card-header"),
    CARD_HEADER_TABS("card-header-tabs"),
    CARD_TITLE("card-title"),
    CLOSE("close"),
    COLLAPSE("collapse"),
    COL_FORM_LABEL("col-form-label"),
    COL_LG("col-lg"),
    COL_LG_1("col-lg-1"),
    COL_LG_2("col-lg-2"),
    COL_LG_3("col-lg-3"),
    COL_LG_4("col-lg-4"),
    COL_LG_5("col-lg-5"),
    COL_LG_6("col-lg-6"),
    COL_LG_7("col-lg-7"),
    COL_LG_8("col-lg-8"),
    COL_LG_9("col-lg-9"),
    COL_LG_10("col-lg-10"),
    COL_LG_11("col-lg-11"),
    COL_LG_12("col-lg-12"),
    COL_LG_AUTO("col-lg-auto"),
    COL_MD("col-md"),
    COL_MD_1("col-md-1"),
    COL_MD_2("col-md-2"),
    COL_MD_3("col-md-3"),
    COL_MD_4("col-md-4"),
    COL_MD_5("col-md-5"),
    COL_MD_6("col-md-6"),
    COL_MD_7("col-md-7"),
    COL_MD_8("col-md-8"),
    COL_MD_9("col-md-9"),
    COL_MD_10("col-md-10"),
    COL_MD_11("col-md-11"),
    COL_MD_12("col-md-12"),
    COL_MD_AUTO("col-md-auto"),
    COL_SM("col-sm"),
    COL_SM_1("col-sm-1"),
    COL_SM_2("col-sm-2"),
    COL_SM_3("col-sm-3"),
    COL_SM_4("col-sm-4"),
    COL_SM_5("col-sm-5"),
    COL_SM_6("col-sm-6"),
    COL_SM_7("col-sm-7"),
    COL_SM_8("col-sm-8"),
    COL_SM_9("col-sm-9"),
    COL_SM_10("col-sm-10"),
    COL_SM_11("col-sm-11"),
    COL_SM_12("col-sm-12"),
    COL_SM_AUTO("col-sm-auto"),
    COL_XL("col-xl"),
    COL_XL_1("col-xl-1"),
    COL_XL_2("col-xl-2"),
    COL_XL_3("col-xl-3"),
    COL_XL_4("col-xl-4"),
    COL_XL_5("col-xl-5"),
    COL_XL_6("col-xl-6"),
    COL_XL_7("col-xl-7"),
    COL_XL_8("col-xl-8"),
    COL_XL_9("col-xl-9"),
    COL_XL_10("col-xl-10"),
    COL_XL_11("col-xl-11"),
    COL_XL_12("col-xl-12"),
    COL_XL_AUTO("col-xl-auto"),
    COL("col"),
    COL_1("col-1"),
    COL_2("col-2"),
    COL_3("col-3"),
    COL_4("col-4"),
    COL_5("col-5"),
    COL_6("col-6"),
    COL_7("col-7"),
    COL_8("col-8"),
    COL_9("col-9"),
    COL_10("col-10"),
    COL_11("col-11"),
    COL_12("col-12"),
    COL_AUTO("col-auto"),
    COL_XS_1("col-1"),
    COL_XS_2("col-2"),
    COL_XS_3("col-3"),
    COL_XS_4("col-4"),
    COL_XS_5("col-5"),
    COL_XS_6("col-6"),
    COL_XS_7("col-7"),
    COL_XS_8("col-8"),
    COL_XS_9("col-9"),
    COL_XS_10("col-10"),
    COL_XS_11("col-11"),
    COL_XS_12("col-12"),
    CONTAINER("container"),
    CONTAINER_FLUID("container-fluid"),
    CUSTOM_CHECKBOX("custom-checkbox"),
    CUSTOM_CONTROL("custom-control"),
    CUSTOM_CONTROL_LABEL("custom-control-label"),
    CUSTOM_CONTROL_INLINE("custom-control-inline"),
    CUSTOM_CONTROL_INPUT("custom-control-input"),
    CUSTOM_FILE("custom-file"),
    CUSTOM_FILE_INPUT("custom-file-input"),
    CUSTOM_FILE_LABEL("custom-file-label"),
    CUSTOM_RADIO("custom-radio"),
    CUSTOM_SELECT("custom-select"),
    CUSTOM_SWITCH("custom-switch"),
    D_FLEX("d-flex"),
    D_INLINE("d-inline"),
    D_NONE("d-none"),
    D_SM_NONE("d-sm-none"),
    DISABLED("disabled"),
    DROPDOWN("dropdown"),
    DROPDOWN_DIVIDER("dropdown-divider"),
    DROPDOWN_ITEM("dropdown-item"),
    DROPDOWN_MENU("dropdown-menu"),
    DROPDOWN_MENU_RIGHT("dropdown-menu-right"),
    DROPDOWN_TOGGLE("dropdown-toggle"),
    FADE("fade"),
    FIGURE("figure"),
    FIGURE_CAPTION("figure-caption"),
    FIGURE_IMG("figure-img"),
    FIXED_BOTTOM("fixed-bottom"),
    FIXED_TOP("fixed-top"),
    FLEX_COLUMN("flex-column"),
    FLEX_COLUMN_REVERSE("flex-column-reverse"),
    FLEX_ROW("flex-row"),
    FLEX_ROW_REVERSE("flex-row-reverse"),
    FONT_ITALIC("font-italic"),
    FONT_WEIGHT_BOLD("font-weight-bold"),
    FONT_WEIGHT_LIGHT("font-weight-light"),
    FORM_CHECK("form-check"),
    FORM_CHECK_INLINE("form-check-inline"),
    FORM_CHECK_INPUT("form-check-input"),
    FORM_CHECK_LABEL("form-check-label"),
    FORM_CONTROL("form-control"),
    FORM_CONTROL_PLAINTEXT("form-control-plaintext"),
    FORM_CONTROL_STATIC("form-control-plaintext"),
    FORM_GROUP("form-group"),
    FORM_INLINE("form-inline"),
    HAS_DANGER("has-danger"),
    HAS_SUCCESS("has-success"),
    HAS_WARNING("has-warning"),
    HIDDEN_SM_UP("d-sm-none"),
    INPUT_GROUP("input-group"),
    INPUT_GROUP_APPEND("input-group-append"),
    INPUT_GROUP_ADDON("input-group-addon"),
    INPUT_GROUP_BTN("input-group-btn"),
    INPUT_GROUP_PREPEND("input-group-prepend"),
    INPUT_GROUP_TEXT("input-group-text"),
    INVISIBLE("invisible"),
    JUSTIFY_CONTENT_AROUND("justify-content-around"),
    JUSTIFY_CONTENT_BETWEEN("justify-content-between"),
    JUSTIFY_CONTENT_CENTER("justify-content-center"),
    JUSTIFY_CONTENT_END("justify-content-end"),
    JUSTIFY_CONTENT_START("justify-content-start"),
    ML_AUTO("ml-auto"),
    ML_LG_AUTO("ml-lg-auto"),
    ML_MD_AUTO("ml-md-auto"),
    ML_SM_AUTO("ml-sm-auto"),
    ML_XL_AUTO("ml-xl-auto"),
    MODAL("modal"),
    MODAL_CONTENT("modal-content"),
    MODAL_DIALOG("modal-dialog"),
    MODAL_LG("modal-lg"),
    MODAL_SM("modal-sm"),
    MR_AUTO("mr-auto"),
    MR_LG_AUTO("mr-lg-auto"),
    MR_MD_AUTO("mr-md-auto"),
    MR_SM_AUTO("mr-sm-auto"),
    MR_XL_AUTO("mr-xl-auto"),
    MY_LG_0("my-lg-0"),
    MY_LG_1("my-lg-1"),
    MY_LG_2("my-lg-2"),
    MY_LG_3("my-lg-3"),
    MY_LG_4("my-lg-4"),
    MY_LG_5("my-lg-5"),
    MX_AUTO("mx-auto"),
    MX_LG_AUTO("mx-lg-auto"),
    MX_MD_AUTO("mx-md-auto"),
    MX_SM_AUTO("mx-sm-auto"),
    MX_XL_AUTO("mx-xl-auto"),
    NAV("nav"),
    NAV_ITEM("nav-item"),
    NAV_LINK("nav-link"),
    NAV_TABS("nav-tabs"),
    NAVBAR("navbar"),
    NAVBAR_COLLAPSE("navbar-collapse"),
    NAVBAR_BRAND("navbar-brand"),
    NAVBAR_DARK("navbar-dark"),
    NAVBAR_EXPAND("navbar-expand"),
    NAVBAR_EXPAND_LG("navbar-expand-lg"),
    NAVBAR_EXPAND_MD("navbar-expand-md"),
    NAVBAR_EXPAND_SM("navbar-expand-sm"),
    NAVBAR_EXPAND_XL("navbar-expand-xl"),
    NAVBAR_FIXED_BOTTOM("fixed-bottom"),
    NAVBAR_FIXED_TOP("fixed-top"),
    NAVBAR_INVERSE("navbar-inverse"),
    NAVBAR_LIGHT("navbar-light"),
    NAVBAR_NAV("navbar-nav"),
    NAVBAR_TOGGLEABLE("navbar-expand-sm"),
    NAVBAR_TOGGLEABLE_XS("navbar-expand-sm"),
    NAVBAR_TOGGLER("navbar-toggler"),
    NAVBAR_TOGGLER_ICON("navbar-toggler-icon"),
    NAVBAR_TOGGLER_LEFT("navbar-toggler-left"),
    NAVBAR_TOGGLER_RIGHT("navbar-toggler-right"),
    OFFSET_1("offset-1"),
    OFFSET_2("offset-2"),
    OFFSET_3("offset-3"),
    OFFSET_4("offset-4"),
    OFFSET_5("offset-5"),
    OFFSET_6("offset-6"),
    OFFSET_7("offset-7"),
    OFFSET_8("offset-8"),
    OFFSET_9("offset-9"),
    OFFSET_10("offset-10"),
    OFFSET_11("offset-11"),
    OFFSET_LG_0("offset-lg-0"),
    OFFSET_LG_1("offset-lg-1"),
    OFFSET_LG_2("offset-lg-2"),
    OFFSET_LG_3("offset-lg-3"),
    OFFSET_LG_4("offset-lg-4"),
    OFFSET_LG_5("offset-lg-5"),
    OFFSET_LG_6("offset-lg-6"),
    OFFSET_LG_7("offset-lg-7"),
    OFFSET_LG_8("offset-lg-8"),
    OFFSET_LG_9("offset-lg-9"),
    OFFSET_LG_10("offset-lg-10"),
    OFFSET_LG_11("offset-lg-11"),
    OFFSET_MD_0("offset-md-0"),
    OFFSET_MD_1("offset-md-1"),
    OFFSET_MD_2("offset-md-2"),
    OFFSET_MD_3("offset-md-3"),
    OFFSET_MD_4("offset-md-4"),
    OFFSET_MD_5("offset-md-5"),
    OFFSET_MD_6("offset-md-6"),
    OFFSET_MD_7("offset-md-7"),
    OFFSET_MD_8("offset-md-8"),
    OFFSET_MD_9("offset-md-9"),
    OFFSET_MD_10("offset-md-10"),
    OFFSET_MD_11("offset-md-11"),
    OFFSET_SM_0("offset-sm-0"),
    OFFSET_SM_1("offset-sm-1"),
    OFFSET_SM_2("offset-sm-2"),
    OFFSET_SM_3("offset-sm-3"),
    OFFSET_SM_4("offset-sm-4"),
    OFFSET_SM_5("offset-sm-5"),
    OFFSET_SM_6("offset-sm-6"),
    OFFSET_SM_7("offset-sm-7"),
    OFFSET_SM_8("offset-sm-8"),
    OFFSET_SM_9("offset-sm-9"),
    OFFSET_SM_10("offset-sm-10"),
    OFFSET_SM_11("offset-sm-11"),
    OFFSET_XL_0("offset-xl-0"),
    OFFSET_XL_1("offset-xl-1"),
    OFFSET_XL_2("offset-xl-2"),
    OFFSET_XL_3("offset-xl-3"),
    OFFSET_XL_4("offset-xl-4"),
    OFFSET_XL_5("offset-xl-5"),
    OFFSET_XL_6("offset-xl-6"),
    OFFSET_XL_7("offset-xl-7"),
    OFFSET_XL_8("offset-xl-8"),
    OFFSET_XL_9("offset-xl-9"),
    OFFSET_XL_10("offset-xl-10"),
    OFFSET_XL_11("offset-xl-11"),
    OPEN("show"),
    PAGE_ITEM("page-item"),
    PAGE_LINK("page-link"),
    PAGINATION("pagination"),
    PROGRESS("progress"),
    PROGRESS_BAR("progress-bar"),
    ROW("row"),
    SHOW("show"),
    SR_ONLY("sr-only"),
    TEXT_DANGER("text-danger"),
    TEXT_DARK("text-dark"),
    TEXT_INFO("text-info"),
    TEXT_LIGHT("text-light"),
    TEXT_PRIMARY("text-primary"),
    TEXT_SECONDARY("text-secondary"),
    TEXT_SUCCESS("text-success"),
    TEXT_WARNING("text-warning"),
    TEXT_CENTER("text-center"),
    TEXT_JUSTIFY("text-justify"),
    TEXT_LEFT("text-left"),
    TEXT_RIGHT("text-right"),
    TAB_CONTENT("tab-content"),
    TAB_PANE("tab-pane"),
    TABLE("table"),
    TABLE_BORDERED("table-bordered"),
    TABLE_DARK("table-dark"),
    TABLE_HOVER("table-hover"),
    TABLE_INFO("table-info"),
    TABLE_INVERSE("table-dark"),
    TABLE_SM("table-sm"),
    TABLE_STRIPED("table-striped");

    private static final Logger LOG;
    private static final int SEVERITY_ERROR;
    private static final int SEVERITY_WARN;
    private static final int SEVERITY_INFO;
    private final String name;

    private BootstrapClass(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static CssItem alert(FacesMessage.Severity severity) {
        if (severity == null) {
            return null;
        }
        if (severity.getOrdinal() >= SEVERITY_ERROR) {
            return ALERT_DANGER;
        }
        if (severity.getOrdinal() >= SEVERITY_WARN) {
            return ALERT_WARNING;
        }
        if (severity.getOrdinal() >= SEVERITY_INFO) {
            return ALERT_INFO;
        }
        return null;
    }

    public static CssItem borderColor(FacesMessage.Severity severity) {
        if (severity == null) {
            return null;
        }
        return BootstrapClass.getSeverityCssItem(severity, BORDER_INFO, BORDER_WARNING, BORDER_DANGER);
    }

    public static CssItem buttonColor(FacesMessage.Severity severity) {
        if (severity == null) {
            return null;
        }
        return BootstrapClass.getSeverityCssItem(severity, BTN_INFO, BTN_WARNING, BTN_DANGER);
    }

    private static CssItem getSeverityCssItem(FacesMessage.Severity severity, BootstrapClass info, BootstrapClass warning, BootstrapClass error) {
        if (severity.equals(FacesMessage.SEVERITY_INFO)) {
            return info;
        }
        if (severity.equals(FacesMessage.SEVERITY_WARN)) {
            return warning;
        }
        return error;
    }

    @Deprecated
    public static CssItem maximumSeverity(UIComponent input) {
        FacesMessage.Severity maximumSeverity = ComponentUtils.getMaximumSeverity(input);
        if (maximumSeverity == null) {
            return null;
        }
        if (maximumSeverity.getOrdinal() >= SEVERITY_ERROR) {
            return HAS_DANGER;
        }
        if (maximumSeverity.getOrdinal() >= SEVERITY_WARN) {
            return HAS_WARNING;
        }
        if (maximumSeverity.getOrdinal() >= SEVERITY_INFO) {
            return TobagoClass.HAS__INFO;
        }
        return null;
    }

    public static CssItem textAlign(TextAlign textAlign) {
        switch (textAlign) {
            case left: {
                return TEXT_LEFT;
            }
            case right: {
                return TEXT_RIGHT;
            }
            case justify: {
                return TEXT_JUSTIFY;
            }
            case center: {
                return TEXT_CENTER;
            }
        }
        LOG.warn("Not a bootstrap class defined for {}", (Object)textAlign);
        return TEXT_LEFT;
    }

    public static CssItem textColor(Markup markup) {
        if (markup == null || markup.contains(Markup.NONE)) {
            return null;
        }
        if (markup.contains(Markup.PRIMARY)) {
            return TEXT_PRIMARY;
        }
        if (markup.contains(Markup.SECONDARY)) {
            return TEXT_SECONDARY;
        }
        if (markup.contains(Markup.SUCCESS)) {
            return TEXT_SUCCESS;
        }
        if (markup.contains(Markup.DANGER)) {
            return TEXT_DANGER;
        }
        if (markup.contains(Markup.WARNING)) {
            return TEXT_WARNING;
        }
        if (markup.contains(Markup.INFO)) {
            return TEXT_INFO;
        }
        if (markup.contains(Markup.LIGHT)) {
            return TEXT_LIGHT;
        }
        if (markup.contains(Markup.DARK)) {
            return TEXT_DARK;
        }
        return null;
    }

    public static CssItem fontStyle(Markup markup) {
        if (markup == null || markup.contains(Markup.NONE)) {
            return null;
        }
        if (markup.contains(Markup.BOLD)) {
            return FONT_WEIGHT_BOLD;
        }
        if (markup.contains(Markup.THIN)) {
            return FONT_WEIGHT_LIGHT;
        }
        if (markup.contains(Markup.ITALIC)) {
            return FONT_ITALIC;
        }
        return null;
    }

    public static BootstrapClass valueOf(Measure measure, Attributes attributes) {
        String size = BootstrapClass.getSizeSuffix(attributes);
        if (measure != null) {
            if (measure.getUnit() == Measure.Unit.FR) {
                return BootstrapClass.valueOf("COL" + size);
            }
            if (measure.getUnit() == Measure.Unit.AUTO) {
                return BootstrapClass.valueOf("COL" + size + "_AUTO");
            }
            if (measure.getUnit() == Measure.Unit.SEG) {
                float value = measure.getValue();
                return BootstrapClass.valueOf("COL" + size + "_" + (value == (float)((long)value) ? Long.toString((long)value) : Float.toString(value)));
            }
        }
        return null;
    }

    public static BootstrapClass valueOf(Margin margin, Attributes attribute) {
        String size = BootstrapClass.getSizeSuffix(attribute);
        switch (margin) {
            case left: {
                return BootstrapClass.valueOf("ML" + size + "_AUTO");
            }
            case right: {
                return BootstrapClass.valueOf("MR" + size + "_AUTO");
            }
            case both: {
                return BootstrapClass.valueOf("MX" + size + "_AUTO");
            }
        }
        return null;
    }

    private static String getSizeSuffix(Attributes attribute) {
        switch (attribute) {
            case extraLarge: 
            case marginExtraLarge: 
            case overwriteExtraLarge: 
            case overwriteMarginExtraLarge: {
                return "_XL";
            }
            case large: 
            case marginLarge: 
            case overwriteLarge: 
            case overwriteMarginLarge: {
                return "_LG";
            }
            case medium: 
            case marginMedium: 
            case overwriteMedium: 
            case overwriteMarginMedium: {
                return "_MD";
            }
            case small: 
            case marginSmall: 
            case overwriteSmall: 
            case overwriteMarginSmall: {
                return "_SM";
            }
        }
        return "";
    }

    public static CssItem valueOf(AlignItems alignItems) {
        if (alignItems == null) {
            return null;
        }
        switch (alignItems) {
            case baseline: {
                return ALIGN_ITEMS_BASELINE;
            }
            case center: {
                return ALIGN_ITEMS_CENTER;
            }
            case flexEnd: {
                return ALIGN_ITEMS_END;
            }
            case flexStart: {
                return ALIGN_ITEMS_START;
            }
            case stretch: {
                return ALIGN_ITEMS_STRETCH;
            }
        }
        LOG.warn("Undefined alignItems: '{}'.", (Object)alignItems);
        return null;
    }

    public static CssItem valueOf(JustifyContent justifyContent) {
        if (justifyContent == null) {
            return null;
        }
        switch (justifyContent) {
            case center: {
                return JUSTIFY_CONTENT_CENTER;
            }
            case flexEnd: {
                return JUSTIFY_CONTENT_END;
            }
            case flexStart: {
                return JUSTIFY_CONTENT_START;
            }
            case spaceBetween: {
                return JUSTIFY_CONTENT_BETWEEN;
            }
            case spaceAround: {
                return JUSTIFY_CONTENT_AROUND;
            }
        }
        LOG.warn("Undefined justifyContent: '{}'.", (Object)justifyContent);
        return null;
    }

    static {
        LOG = LoggerFactory.getLogger(BootstrapClass.class);
        SEVERITY_ERROR = FacesMessage.SEVERITY_ERROR.getOrdinal();
        SEVERITY_WARN = FacesMessage.SEVERITY_WARN.getOrdinal();
        SEVERITY_INFO = FacesMessage.SEVERITY_INFO.getOrdinal();
    }

    public static class Generator {
        private static final BootstrapClass[] OFFSET_EXTRA_SMALL = new BootstrapClass[]{null, OFFSET_1, OFFSET_2, OFFSET_3, OFFSET_4, OFFSET_5, OFFSET_6, OFFSET_7, OFFSET_8, OFFSET_9, OFFSET_10, OFFSET_11};
        private static final BootstrapClass[] OFFSET_SMALL = new BootstrapClass[]{OFFSET_SM_0, OFFSET_SM_1, OFFSET_SM_2, OFFSET_SM_3, OFFSET_SM_4, OFFSET_SM_5, OFFSET_SM_6, OFFSET_SM_7, OFFSET_SM_8, OFFSET_SM_9, OFFSET_SM_10, OFFSET_SM_11};
        private static final BootstrapClass[] OFFSET_MEDIUM = new BootstrapClass[]{OFFSET_MD_0, OFFSET_MD_1, OFFSET_MD_2, OFFSET_MD_3, OFFSET_MD_4, OFFSET_MD_5, OFFSET_MD_6, OFFSET_MD_7, OFFSET_MD_8, OFFSET_MD_9, OFFSET_MD_10, OFFSET_MD_11};
        private static final BootstrapClass[] OFFSET_LARGE = new BootstrapClass[]{OFFSET_LG_0, OFFSET_LG_1, OFFSET_LG_2, OFFSET_LG_3, OFFSET_LG_4, OFFSET_LG_5, OFFSET_LG_6, OFFSET_LG_7, OFFSET_LG_8, OFFSET_LG_9, OFFSET_LG_10, OFFSET_LG_11};
        private static final BootstrapClass[] OFFSET_EXTRA_LARGE = new BootstrapClass[]{OFFSET_XL_0, OFFSET_XL_1, OFFSET_XL_2, OFFSET_XL_3, OFFSET_XL_4, OFFSET_XL_5, OFFSET_XL_6, OFFSET_XL_7, OFFSET_XL_8, OFFSET_XL_9, OFFSET_XL_10, OFFSET_XL_11};
        private final MeasureList extraSmall;
        private final MeasureList small;
        private final MeasureList medium;
        private final MeasureList large;
        private final MeasureList extraLarge;
        private final MarginTokens marginExtraSmall;
        private final MarginTokens marginSmall;
        private final MarginTokens marginMedium;
        private final MarginTokens marginLarge;
        private final MarginTokens marginExtraLarge;
        private int index = 0;

        public Generator(MeasureList extraSmall, MeasureList small, MeasureList medium, MeasureList large, MeasureList extraLarge, MarginTokens marginExtraSmall, MarginTokens marginSmall, MarginTokens marginMedium, MarginTokens marginLarge, MarginTokens marginExtraLarge) {
            this.extraSmall = extraSmall == null && small == null && medium == null && large == null && extraLarge == null ? MeasureList.parse("*") : extraSmall;
            this.small = small;
            this.medium = medium;
            this.large = large;
            this.extraLarge = extraLarge;
            this.marginExtraSmall = marginExtraSmall;
            this.marginSmall = marginSmall;
            this.marginMedium = marginMedium;
            this.marginLarge = marginLarge;
            this.marginExtraLarge = marginExtraLarge;
        }

        public void reset() {
            this.index = 0;
        }

        public void next() {
            ++this.index;
        }

        public BootstrapClass[] generate(UIComponent child) {
            ArrayList<BootstrapClass> result = new ArrayList<BootstrapClass>(10);
            Map attributes = child.getAttributes();
            this.generate(result, this.extraSmall, (Map<String, Object>)attributes, Attributes.overwriteExtraSmall);
            this.generate(result, this.small, (Map<String, Object>)attributes, Attributes.overwriteSmall);
            this.generate(result, this.medium, (Map<String, Object>)attributes, Attributes.overwriteMedium);
            this.generate(result, this.large, (Map<String, Object>)attributes, Attributes.overwriteLarge);
            this.generate(result, this.extraLarge, (Map<String, Object>)attributes, Attributes.overwriteExtraLarge);
            this.generate(result, this.marginExtraSmall, (Map<String, Object>)attributes, Attributes.overwriteMarginExtraSmall);
            this.generate(result, this.marginSmall, (Map<String, Object>)attributes, Attributes.overwriteMarginSmall);
            this.generate(result, this.marginMedium, (Map<String, Object>)attributes, Attributes.overwriteMarginMedium);
            this.generate(result, this.marginLarge, (Map<String, Object>)attributes, Attributes.overwriteMarginLarge);
            this.generate(result, this.marginExtraLarge, (Map<String, Object>)attributes, Attributes.overwriteMarginExtraLarge);
            this.generateOffset(result, attributes.get(Attributes.offsetExtraSmall.name()), OFFSET_EXTRA_SMALL);
            this.generateOffset(result, attributes.get(Attributes.offsetSmall.name()), OFFSET_SMALL);
            this.generateOffset(result, attributes.get(Attributes.offsetMedium.name()), OFFSET_MEDIUM);
            this.generateOffset(result, attributes.get(Attributes.offsetLarge.name()), OFFSET_LARGE);
            this.generateOffset(result, attributes.get(Attributes.offsetExtraLarge.name()), OFFSET_EXTRA_LARGE);
            return result.toArray(new BootstrapClass[0]);
        }

        private void generate(List<BootstrapClass> result, MeasureList tokens, Map<String, Object> attributes, Attributes attribute) {
            Object overwrite = attributes.get(attribute.name());
            if (overwrite != null) {
                Measure measure = Measure.valueOf(overwrite.toString(), Measure.Unit.SEG);
                BootstrapClass bootstrapClass = BootstrapClass.valueOf(this.getSegmentMeasure(measure), attribute);
                result.add(bootstrapClass);
            } else if (tokens != null && tokens.getSize() > 0) {
                Measure measure = tokens.get(this.index % tokens.getSize());
                BootstrapClass bootstrapClass = BootstrapClass.valueOf(this.getSegmentMeasure(measure), attribute);
                result.add(bootstrapClass);
            }
        }

        private Measure getSegmentMeasure(Measure measure) {
            if (measure != null && Measure.Unit.SEG.equals((Object)measure.getUnit())) {
                int number = (int)measure.getValue();
                if (number < 1) {
                    LOG.warn("Segment values must been between 1 and 12. Use '1' instead of '{}'.", (Object)number);
                    return new Measure(1, Measure.Unit.SEG);
                }
                if (number > 12) {
                    LOG.warn("Segment values must been between 1 and 12. Use '12' instead of '{}'.", (Object)number);
                    return new Measure(12, Measure.Unit.SEG);
                }
            }
            return measure;
        }

        private void generate(List<BootstrapClass> result, MarginTokens margins, Map<String, Object> attributes, Attributes attribute) {
            Object overwrite = attributes.get(attribute.name());
            if (overwrite != null) {
                Margin margin = MarginTokens.parseToken((String)overwrite);
                BootstrapClass bootstrapClass = BootstrapClass.valueOf(margin, attribute);
                result.add(bootstrapClass);
            } else if (margins != null && margins.getSize() > 0) {
                Margin margin = margins.get(this.index % margins.getSize());
                BootstrapClass bootstrapClass = BootstrapClass.valueOf(margin, attribute);
                result.add(bootstrapClass);
            }
        }

        private void generateOffset(List<BootstrapClass> result, Object offset, BootstrapClass[] values) {
            int offsetIndex;
            if (offset != null && (offsetIndex = Integer.valueOf((String)offset).intValue()) >= 0) {
                offsetIndex = offsetIndex > 11 ? 11 : offsetIndex;
                result.add(values[offsetIndex]);
            }
        }
    }
}

