/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUICollapsiblePanel;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class PanelRendererBase
extends RendererBase {
    private static final String SUFFIX_COLLAPSE = "collapse";

    public void decode(FacesContext facesContext, UIComponent component) {
        String newValue;
        super.decode(facesContext, component);
        AbstractUICollapsiblePanel collapsible = (AbstractUICollapsiblePanel)component;
        String clientId = collapsible.getClientId(facesContext);
        String hiddenId = clientId + "::" + SUFFIX_COLLAPSE;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(hiddenId) && StringUtils.isNotBlank(newValue = (String)requestParameterMap.get(hiddenId))) {
            collapsible.setSubmittedCollapsed(Boolean.valueOf(newValue));
        }
    }

    protected void encodeHidden(TobagoResponseWriter writer, String clientId, boolean collapsed) throws IOException {
        String hiddenId = clientId + "::" + SUFFIX_COLLAPSE;
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute(hiddenId);
        writer.writeIdAttribute(hiddenId);
        writer.writeAttribute(HtmlAttributes.VALUE, Boolean.toString(collapsed), false);
        writer.endElement(HtmlElements.INPUT);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (((AbstractUICollapsiblePanel)component).isNormalLifecycle()) {
            super.encodeChildren(facesContext, component);
        }
    }
}

