/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PreRenderComponentEvent;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.util.StyleRenderUtils;
import org.apache.myfaces.tobago.layout.GridSpan;
import org.apache.myfaces.tobago.layout.MeasureList;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PreRenderComponentEvent.class)
public abstract class AbstractUIGridLayout
extends AbstractUILayoutBase
implements ComponentSystemEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.tobago.GridLayout";
    private static final int STEP = 5;
    protected static final UIComponent SPAN = new UIPanel();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        if (!this.isRendered()) {
            return;
        }
        if (event instanceof PreRenderComponentEvent) {
            this.layout(MeasureList.parse(this.getColumns()).getSize(), MeasureList.parse(this.getRows()).getSize(), ComponentUtils.findLayoutChildren((UIComponent)this));
        }
    }

    public abstract String getRows();

    public abstract void setRows(String var1);

    public abstract String getColumns();

    public abstract void setColumns(String var1);

    protected UIComponent[][] layout(int columnsCount, int initialRowsCount, List<UIComponent> components) {
        Map attributes;
        assert (columnsCount > 0);
        assert (initialRowsCount > 0);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIComponent[][] cells = new UIComponent[initialRowsCount][columnsCount];
        for (UIComponent component : components) {
            Map attributes2 = component.getAttributes();
            Integer gridColumn = (Integer)attributes2.get(Attributes.gridColumn.getName());
            Integer gridRow = (Integer)attributes2.get(Attributes.gridRow.getName());
            if (gridColumn != null && gridRow != null) {
                if (gridColumn > columnsCount) {
                    LOG.warn("gridColumn {} > columnsCount {} in component '{}'!", new Object[]{gridColumn, columnsCount, component.getClientId(facesContext)});
                    continue;
                }
                if (gridRow > cells.length) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("expanding, because gridRow {} > rowCount {} in component '{}'!", new Object[]{gridRow, cells.length, component.getClientId(facesContext)});
                    }
                    cells = this.expand(cells, gridRow);
                }
                cells = this.set(cells, gridColumn - 1, gridRow - 1, component);
                continue;
            }
            if (gridColumn != null) {
                LOG.warn("gridColumn is set to {}, but gridRow not in component '{}'!", (Object)gridColumn, (Object)component.getClientId(facesContext));
                continue;
            }
            if (gridRow == null) continue;
            LOG.warn("gridRow is set to {}, but gridColumn not in component '{}'!", (Object)gridRow, (Object)component.getClientId(facesContext));
        }
        int j = 0;
        int i = 0;
        for (UIComponent component : components) {
            attributes = component.getAttributes();
            Integer gridColumn = (Integer)attributes.get(Attributes.gridColumn.getName());
            Integer gridRow = (Integer)attributes.get(Attributes.gridRow.getName());
            if (gridColumn != null && gridRow != null) continue;
            while (cells[j][i] != null) {
                if (++i >= columnsCount) {
                    i = 0;
                    ++j;
                }
                if (j < cells.length) continue;
                cells = this.expand(cells, j + 5);
            }
            cells = this.set(cells, i, j, component);
        }
        for (UIComponent component : components) {
            attributes = component.getAttributes();
            int gridColumn = (Integer)attributes.get(Attributes.gridColumn.getName());
            Integer columnSpan = (Integer)attributes.get(Attributes.columnSpan.getName());
            int gridRow = (Integer)attributes.get(Attributes.gridRow.getName());
            Integer rowSpan = (Integer)attributes.get(Attributes.rowSpan.getName());
            boolean labeledLeft = LabelLayout.isGridLeft(component);
            boolean labeledRight = LabelLayout.isGridRight(component);
            boolean labeledHorizontal = labeledLeft || labeledRight;
            boolean labeledTop = LabelLayout.isGridTop(component);
            boolean labeledBottom = LabelLayout.isGridBottom(component);
            boolean labeledVertical = labeledTop || labeledBottom;
            boolean labeled = labeledHorizontal || labeledVertical;
            AbstractUIStyle fieldStyle = ComponentUtils.findChild(component, AbstractUIStyle.class);
            if (fieldStyle == null) {
                fieldStyle = (AbstractUIStyle)ComponentUtils.createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style, null);
                component.getChildren().add(fieldStyle);
            }
            fieldStyle.setTransient(true);
            fieldStyle.setGridColumn(GridSpan.valueOf(labeledLeft ? gridColumn + 1 : gridColumn, labeledHorizontal ? columnSpan - 1 : columnSpan));
            fieldStyle.setGridRow(GridSpan.valueOf(labeledTop ? gridRow + 1 : gridRow, labeledVertical ? rowSpan - 1 : rowSpan));
            if (!labeled) continue;
            AbstractUIStyle labelStyle = (AbstractUIStyle)ComponentUtils.createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style, null);
            component.getChildren().add(labelStyle);
            labelStyle.setTransient(true);
            labelStyle.setSelector(StyleRenderUtils.encodeIdSelector(component.getClientId(facesContext) + "::" + "label"));
            labelStyle.setGridColumn(GridSpan.valueOf(labeledRight ? gridColumn + columnSpan - 1 : gridColumn, null));
            labelStyle.setGridRow(GridSpan.valueOf(labeledBottom ? gridRow + rowSpan - 1 : gridRow, null));
        }
        return cells;
    }

    private UIComponent[][] set(UIComponent[][] initialCells, Integer column, Integer row, UIComponent component) {
        UIComponent[][] cells = initialCells;
        Map attributes = component.getAttributes();
        int rowSpan = ComponentUtils.getIntAttribute(component, Attributes.rowSpan, LabelLayout.isGridTop(component) || LabelLayout.isGridBottom(component) ? 2 : 1);
        ComponentUtils.setAttribute(component, Attributes.rowSpan, rowSpan);
        int columnSpan = ComponentUtils.getIntAttribute(component, Attributes.columnSpan, LabelLayout.isGridLeft(component) || LabelLayout.isGridRight(component) ? 2 : 1);
        ComponentUtils.setAttribute(component, Attributes.columnSpan, columnSpan);
        block0: for (int j = row.intValue(); j < rowSpan + row; ++j) {
            for (int i = column.intValue(); i < columnSpan + column; ++i) {
                if (i >= cells[0].length) {
                    LOG.warn("column {} + columnSpan {} - 1 >= columnsCount {} in component '{}'!", new Object[]{column + 1, columnSpan, cells[0].length, component.getClientId(FacesContext.getCurrentInstance())});
                    continue block0;
                }
                if (j >= cells.length) {
                    cells = this.expand(cells, j + 5);
                }
                if (j == row && i == column) {
                    cells[j][i] = component;
                    attributes.put(Attributes.gridRow.getName(), j + 1);
                    attributes.put(Attributes.gridColumn.getName(), i + 1);
                    continue;
                }
                cells[j][i] = SPAN;
            }
        }
        return cells;
    }

    @Deprecated
    protected UIComponent[][] expand(UIComponent[][] cells, Integer minRows, int step) {
        return this.expand(cells, minRows);
    }

    protected UIComponent[][] expand(UIComponent[][] cells, int rows) {
        int columns = cells[0].length;
        UIComponent[][] result = new UIComponent[rows][columns];
        for (int j = 0; j < cells.length; ++j) {
            System.arraycopy(cells[j], 0, result[j], 0, columns);
        }
        return result;
    }
}

