/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.component.SupportsSegmentLayout;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISegmentLayout;
import org.apache.myfaces.tobago.layout.SegmentJustify;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SegmentLayoutRenderer<T extends AbstractUISegmentLayout>
extends RendererBase<T> {
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = component.getMarkup();
        SegmentJustify segmentJustify = component.getJustify();
        writer.startElement(HtmlElements.TOBAGO_SEGMENT_LAYOUT);
        writer.writeIdAttribute(component.getClientId(facesContext));
        writer.writeClassAttribute(BootstrapClass.ROW, segmentJustify != null ? BootstrapClass.segmentJustify(segmentJustify) : null, markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
    }

    @Override
    public void encodeChildrenInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (!component.isRendered()) {
            return;
        }
        List<UIComponent> children = ComponentUtils.findLayoutChildren(component);
        BootstrapClass.Generator generator = new BootstrapClass.Generator((SupportsSegmentLayout)component);
        for (UIComponent child : children) {
            if (!child.isRendered()) continue;
            this.encodeChild(facesContext, writer, generator, child);
        }
    }

    private void encodeChild(FacesContext facesContext, TobagoResponseWriter writer, BootstrapClass.Generator generator, UIComponent child) throws IOException {
        if (child instanceof SupportsLabelLayout && LabelLayout.isSegment(((SupportsLabelLayout)child).getLabelLayout())) {
            SupportsLabelLayout labeledChild;
            labeledChild.setNextToRenderIsLabel((labeledChild = (SupportsLabelLayout)child).getLabelLayout() == LabelLayout.segmentLeft);
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
            labeledChild.setNextToRenderIsLabel(labeledChild.getLabelLayout() == LabelLayout.segmentRight);
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
            LabelLayout.removeSegment(facesContext);
        } else {
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
        }
    }

    private void encodeDiv(FacesContext facesContext, TobagoResponseWriter writer, BootstrapClass.Generator generator, UIComponent child) throws IOException {
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute((CssItem)null, (CssItem[])null, (CssItem[])generator.generate(child));
        child.encodeAll(facesContext);
        writer.endElement(HtmlElements.DIV);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_SEGMENT_LAYOUT);
    }
}

