/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIProgress;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StyleRenderUtils;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ProgressRenderer<T extends AbstractUIProgress>
extends RendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        double value = ((AbstractUIProgress)component).getRangeValue();
        double max = ((AbstractUIProgress)component).getRangeMax();
        double percent = value / max;
        Markup markup = component.getMarkup();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.TOBAGO_PROGRESS);
        String clientId = component.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(BootstrapClass.PROGRESS, component.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.PROGRESS_BAR);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.PROGRESSBAR.toString(), false);
        writer.writeAttribute((MarkupLanguageAttributes)Arias.VALUEMIN, 0);
        writer.writeAttribute((MarkupLanguageAttributes)Arias.VALUEMAX, 100);
        writer.writeAttribute(Arias.VALUENOW, String.valueOf((int)percent * 100), false);
        AbstractUIStyle style = (AbstractUIStyle)facesContext.getApplication().createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style.name());
        style.setTransient(true);
        style.setSelector(StyleRenderUtils.encodeIdSelector(clientId) + ">." + BootstrapClass.PROGRESS_BAR.getName());
        style.setWidth(new Measure(percent * 100.0, Measure.Unit.PERCENT));
        component.getChildren().add(style);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.TOBAGO_PROGRESS);
    }
}

