/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.portlet.faces.util.HTTPUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryString {
    private String mQueryString;
    private String mCharacterEncoding;
    private Map<String, List<Parameter>> mParameterMap;
    private List<Parameter> mParameterList;
    private List<String> mParameterNames;

    public QueryString(String queryString, String characterEncoding) {
        this.mQueryString = queryString.replace("&amp;", "&");
        this.mCharacterEncoding = characterEncoding;
    }

    public QueryString(QueryString source) {
        this.mQueryString = source.mQueryString;
        this.mCharacterEncoding = source.mCharacterEncoding;
        if (source.mParameterList != null) {
            this.mParameterList = new ArrayList<Parameter>(source.mParameterList);
        }
    }

    public QueryString(String characterEncoding) {
        this.mCharacterEncoding = characterEncoding;
    }

    public QueryString(String[][] args, String characterEncoding) {
        this(characterEncoding);
        for (String[] element : args) {
            this.addParameter(element[0], element[1], true);
        }
    }

    public QueryString(List<String[]> params, String characterEncoding) {
        this(characterEncoding);
        for (String[] pair : params) {
            this.addParameter(pair[0], pair[1], true);
        }
    }

    public String toString() {
        if (this.mQueryString == null) {
            this.appendTo(new StringBuilder(200));
        }
        return this.mQueryString;
    }

    public void appendTo(StringBuilder buff) {
        if (this.mQueryString == null) {
            if (this.mParameterList == null || this.mParameterList.isEmpty()) {
                this.mQueryString = "";
            } else {
                int startPos = buff.length();
                Iterator<Parameter> iter = this.mParameterList.iterator();
                Parameter param = iter.next();
                buff.append(param.getEncodedName()).append('=').append(param.getEncodedValue());
                while (iter.hasNext()) {
                    param = iter.next();
                    buff.append('&').append(param.getEncodedName()).append('=').append(param.getEncodedValue());
                }
                this.mQueryString = buff.substring(startPos);
            }
        } else {
            buff.append(this.mQueryString);
        }
    }

    public Enumeration<String> getParameterNames() {
        this.initParameterMap();
        return Collections.enumeration(this.mParameterNames);
    }

    public Map getParameterMap() {
        this.initParameterMap();
        return this.mParameterMap;
    }

    public int numParameters() {
        return this.mParameterMap.size();
    }

    public String getParameter(String name) {
        this.initParameterMap();
        List<Parameter> values = this.mParameterMap.get(name);
        return values == null ? null : values.get(0).getValue();
    }

    public Enumeration<String> getParameterValues(String name) {
        this.initParameterMap();
        List<Parameter> params = this.mParameterMap.get(name);
        if (params == null || params.isEmpty()) {
            List temp = Collections.emptyList();
            return Collections.enumeration(temp);
        }
        ArrayList<String> values = new ArrayList<String>(params.size());
        for (Parameter param : params) {
            values.add(param.getValue());
        }
        return Collections.enumeration(values);
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, value, false);
    }

    public void addParameter(String name, String value, boolean isEncoded) {
        if (value == null) {
            return;
        }
        this.initParameterList();
        this.mQueryString = null;
        Parameter param = new Parameter(name, value, isEncoded);
        this.mParameterList.add(param);
        if (this.mParameterMap != null) {
            String decodedName = param.getName();
            List<Parameter> values = this.mParameterMap.get(decodedName);
            if (values == null) {
                this.createParameterList(param);
            } else {
                values.add(param);
            }
        }
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, value, false);
    }

    public void setParameter(String name, String value, boolean isEncoded) {
        if (value == null) {
            this.removeParameter(name, isEncoded);
            return;
        }
        this.initParameterMap();
        this.mQueryString = null;
        Parameter param = new Parameter(name, value, isEncoded);
        String decodedName = param.getName();
        List<Parameter> values = this.mParameterMap.get(decodedName);
        if (values == null) {
            this.createParameterList(param);
            this.mParameterList.add(param);
        } else {
            int j;
            values.clear();
            int i = this.mParameterList.indexOf(param);
            this.mParameterList.set(i, param);
            while ((j = this.mParameterList.lastIndexOf(param)) > i) {
                this.mParameterList.remove(j);
            }
            values.add(param);
        }
    }

    public String removeParameter(String name) {
        return this.removeParameter(name, false);
    }

    public String removeParameter(String name, boolean isEncoded) {
        String decodedName;
        List<Parameter> values;
        this.initParameterList();
        this.mQueryString = null;
        Parameter templateParam = new Parameter(name, "", isEncoded);
        Iterator<Parameter> i = this.mParameterList.iterator();
        Parameter firstParam = null;
        while (i.hasNext()) {
            Parameter param = i.next();
            if (!templateParam.equals(param)) continue;
            if (firstParam == null) {
                firstParam = param;
            }
            i.remove();
        }
        if (firstParam == null) {
            return null;
        }
        if (this.mParameterMap != null && (values = this.mParameterMap.remove(decodedName = templateParam.getName())) != null) {
            this.mParameterNames.remove(decodedName);
        }
        return isEncoded ? firstParam.getEncodedValue() : firstParam.getValue();
    }

    private void createParameterList(Parameter param) {
        String decodedName = param.getName();
        ArrayList<Parameter> values = new ArrayList<Parameter>(4);
        this.mParameterMap.put(decodedName, values);
        this.mParameterNames.add(decodedName);
        values.add(param);
    }

    private void initParameterMap() {
        if (this.mParameterMap == null) {
            this.initParameterList();
            this.mParameterMap = new HashMap<String, List<Parameter>>(30);
            this.mParameterNames = new ArrayList<String>(30);
            if (this.mParameterList.isEmpty()) {
                return;
            }
            for (Parameter param : this.mParameterList) {
                String decodedName = param.getName();
                List<Parameter> values = this.mParameterMap.get(decodedName);
                if (values == null) {
                    this.createParameterList(param);
                    continue;
                }
                values.add(param);
            }
        }
    }

    private void initParameterList() {
        if (this.mParameterList == null) {
            int nextPos;
            int length;
            this.mParameterList = new ArrayList<Parameter>(30);
            if (this.mQueryString == null || (length = this.mQueryString.length()) == 0) {
                return;
            }
            int lastPos = 0;
            do {
                int sepPos;
                if ((nextPos = this.mQueryString.indexOf(38, lastPos)) == -1) {
                    nextPos = length;
                }
                Parameter param = (sepPos = this.mQueryString.indexOf(61, lastPos)) != -1 && sepPos < nextPos ? new Parameter(this.mQueryString.substring(lastPos, sepPos), this.mQueryString.substring(sepPos + 1, nextPos), true) : new Parameter(this.mQueryString.substring(lastPos, nextPos), "", true);
                this.mParameterList.add(param);
                lastPos = nextPos + 1;
            } while (nextPos < length);
        }
    }

    private void handleUnsupportedEncoding() {
        throw new IllegalArgumentException(new StringBuilder(100).append("Unrecognized character encoding \"").append(this.mCharacterEncoding).append('\"').toString());
    }

    private class Parameter {
        private String mName;
        private String mEncodedName;
        private String mValue;
        private String mEncodedValue;

        public Parameter(String name, String value, boolean encoded) {
            if (encoded) {
                this.mEncodedName = name;
                this.mEncodedValue = value;
            } else {
                this.mName = name;
                this.mValue = value;
            }
        }

        public String getName() {
            if (this.mName == null) {
                try {
                    this.mName = HTTPUtils.decode(this.mEncodedName, QueryString.this.mCharacterEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    QueryString.this.handleUnsupportedEncoding();
                }
            }
            return this.mName;
        }

        public String getEncodedName() {
            if (this.mEncodedName == null) {
                try {
                    this.mEncodedName = HTTPUtils.encode(this.mName, QueryString.this.mCharacterEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    QueryString.this.handleUnsupportedEncoding();
                }
            }
            return this.mEncodedName;
        }

        public String getValue() {
            if (this.mValue == null) {
                try {
                    this.mValue = HTTPUtils.decode(this.mEncodedValue, QueryString.this.mCharacterEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    QueryString.this.handleUnsupportedEncoding();
                }
            }
            return this.mValue;
        }

        public String getEncodedValue() {
            if (this.mEncodedValue == null) {
                try {
                    this.mEncodedValue = HTTPUtils.encode(this.mValue, QueryString.this.mCharacterEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    QueryString.this.handleUnsupportedEncoding();
                }
            }
            return this.mEncodedValue;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Parameter)) {
                return false;
            }
            Parameter p1 = (Parameter)o;
            return p1.mName != null && this.getName().equals(p1.mName) || p1.mEncodedName != null && this.getEncodedName().equals(p1.mEncodedName);
        }
    }
}

