/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.convert;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.convert.BaseConverter;
import org.apache.myfaces.trinidadinternal.convert.GenericConverter;
import org.apache.myfaces.trinidadinternal.convert.ReflectionConverter;
import org.apache.myfaces.trinidadinternal.convert.ReverseDiscoveryGenericConverter;
import org.apache.myfaces.trinidadinternal.convert.SqlConverter;
import org.apache.myfaces.trinidadinternal.convert.TypeConversionException;
import org.apache.myfaces.trinidadinternal.convert.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConverterFactory {
    private final Map<Key, TypeConverter> _cache = new ConcurrentHashMap<Key, TypeConverter>(16);
    private final List<GenericConverter> _converters = new ArrayList<GenericConverter>(3);
    private final List<ReverseDiscoveryGenericConverter> _reverseDiscoveryConverters = new ArrayList<ReverseDiscoveryGenericConverter>(2);
    private static final TypeConverter _NULL = new TypeConverter(){

        @Override
        public Object convert(Object source, Class<?> targetType) {
            return null;
        }
    };
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(GenericConverterFactory.class);
    private static final GenericConverterFactory _INSTANCE = new GenericConverterFactory();

    private GenericConverterFactory() {
        this.registerConverter(new SqlConverter());
        this.registerConverter(new BaseConverter());
        this.registerReverseDiscoveryConverter(new ReflectionConverter());
    }

    public TypeConverter getConverter(Class<?> sourceType, Class<?> targetType) {
        Key key = new Key(sourceType, targetType);
        TypeConverter cached = this._cache.get(key);
        if (cached != null) {
            return cached == _NULL ? null : cached;
        }
        Node start = new Node(null, null, sourceType);
        LinkedList<Node> sourcesToBeSearched = new LinkedList<Node>();
        sourcesToBeSearched.add(start);
        HashSet cache = new HashSet(16);
        TypeConverter converter = this._findConverter(sourcesToBeSearched, targetType, cache, false);
        if (converter == null && this._reverseDiscoveryConverters.size() > 0) {
            TypeConverter reverseConv = null;
            reverseConv = this._cache.get(new Key(targetType, sourceType));
            if (reverseConv == null) {
                cache.clear();
                sourcesToBeSearched.add(new Node(null, null, targetType));
                reverseConv = this._findConverter(sourcesToBeSearched, sourceType, cache, false);
            }
            if (reverseConv != null) {
                cache.clear();
                sourcesToBeSearched.clear();
                sourcesToBeSearched.add(start);
                converter = this._findConverter(sourcesToBeSearched, targetType, cache, true);
            }
        }
        if (converter == null) {
            this._cache.put(key, _NULL);
        } else {
            this._cache.put(key, converter);
        }
        return converter;
    }

    private TypeConverter _findConverter(LinkedList<Node> sourcesToBeSearched, Class<?> targetType, Set<Class<?>> cache, boolean useRevserseDiscovery) {
        while (!sourcesToBeSearched.isEmpty()) {
            Node source = sourcesToBeSearched.removeFirst();
            TypeConverter match = null;
            int jsz = this._converters.size();
            for (int j = 0; j < jsz; ++j) {
                GenericConverter conv = this._converters.get(j);
                if (!this._searchTargetTypes(sourcesToBeSearched, source, conv, targetType, cache)) continue;
                match = conv;
            }
            if (match == null && useRevserseDiscovery) {
                match = this._searchSourceTypes(source.targetType, targetType);
            }
            if (match == null) continue;
            if (source.previous == null) {
                return match;
            }
            return new CompositeConverter(source, match, targetType);
        }
        return null;
    }

    private boolean _searchTargetTypes(List<Node> sourcesToBeSearched, Node currentSource, GenericConverter currentConverter, Class<?> searchType, Set<Class<?>> cache) {
        Class<?> sourceType = currentSource.targetType;
        List<Class<?>> targetTypes = currentConverter.getTargetTypes(sourceType);
        int sz = targetTypes.size();
        for (int i = 0; i < sz; ++i) {
            Class<?> targetType = targetTypes.get(i);
            if (!cache.add(targetType)) continue;
            if (searchType.isAssignableFrom(targetType)) {
                return true;
            }
            Node newSource = new Node(currentSource, currentConverter, targetType);
            sourcesToBeSearched.add(newSource);
        }
        return false;
    }

    private TypeConverter _searchSourceTypes(Class<?> sourceType, Class<?> targetType) {
        for (ReverseDiscoveryGenericConverter conv : this._reverseDiscoveryConverters) {
            List<Class<?>> sourceTypes = conv.getSourceTypes(targetType);
            for (Class<?> type : sourceTypes) {
                if (!type.isAssignableFrom(sourceType)) continue;
                return conv;
            }
        }
        return null;
    }

    public void registerConverter(GenericConverter converter) {
        this._converters.add(converter);
        this._cache.clear();
    }

    public void registerReverseDiscoveryConverter(ReverseDiscoveryGenericConverter converter) {
        this._reverseDiscoveryConverters.add(converter);
        this._cache.clear();
    }

    public Object convert(Object source, Class<?> targetType) {
        if (source == null) {
            return null;
        }
        if (targetType.isAssignableFrom(source.getClass())) {
            return source;
        }
        TypeConverter converter = this.getConverter(source.getClass(), targetType);
        if (converter != null) {
            return converter.convert(source, targetType);
        }
        throw new TypeConversionException(source, targetType);
    }

    public boolean isConvertible(Object source, Class<?> targetType) {
        if (source == null) {
            return false;
        }
        if (targetType.isAssignableFrom(source.getClass())) {
            return true;
        }
        TypeConverter converter = this.getConverter(source.getClass(), targetType);
        return converter != null;
    }

    public static GenericConverterFactory getCurrentInstance(ExternalContext extContext) {
        return _INSTANCE;
    }

    public static GenericConverterFactory getCurrentInstance() {
        return GenericConverterFactory.getCurrentInstance(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompositeConverter
    implements TypeConverter {
        private final Node _chain;

        public CompositeConverter(Node source, TypeConverter conv, Class<?> targetType) {
            assert (source != null);
            this._chain = new Node(source, conv, targetType);
        }

        @Override
        public Object convert(Object source, Class<?> targetType) {
            if (targetType.isAssignableFrom(this._chain.targetType)) {
                return this._chain.convert(source);
            }
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_CONVERT", new Object[]{source, targetType.getName()}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Key {
        private final int _hc;
        private final Class<?> _source;
        private final Class<?> _target;

        public Key(Class<?> source, Class<?> target) {
            assert (!source.equals(target));
            this._source = source;
            this._target = target;
            this._hc = source.hashCode() + target.hashCode();
        }

        public int hashCode() {
            return this._hc;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Key) {
                Key that = (Key)other;
                return this._source.equals(that._source) && this._target.equals(that._target);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node {
        public final Node previous;
        public final TypeConverter converter;
        public final Class<?> targetType;

        public Node(Node previous, TypeConverter converter, Class<?> targetType) {
            this.previous = previous;
            this.converter = converter;
            this.targetType = targetType;
        }

        public Object convert(Object source) {
            if (this.previous != null) {
                source = this.previous.convert(source);
                source = this.converter.convert(source, this.targetType);
            }
            return source;
        }
    }
}

