/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.model;

import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jpt.sun.source.util.JavacTask;
import jpt.sun.tools.javac.api.JavacTaskImpl;
import jpt.sun.tools.javac.code.Attribute;
import jpt.sun.tools.javac.code.Directive;
import jpt.sun.tools.javac.code.Kinds;
import jpt.sun.tools.javac.code.Scope;
import jpt.sun.tools.javac.code.Source;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.code.Symtab;
import jpt.sun.tools.javac.code.Type;
import jpt.sun.tools.javac.code.TypeTag;
import jpt.sun.tools.javac.code.Types;
import jpt.sun.tools.javac.comp.AttrContext;
import jpt.sun.tools.javac.comp.Enter;
import jpt.sun.tools.javac.comp.Env;
import jpt.sun.tools.javac.comp.Modules;
import jpt.sun.tools.javac.comp.Resolve;
import jpt.sun.tools.javac.main.JavaCompiler;
import jpt.sun.tools.javac.model.FilteredMemberList;
import jpt.sun.tools.javac.processing.PrintingProcessor;
import jpt.sun.tools.javac.resources.CompilerProperties;
import jpt.sun.tools.javac.tree.JCTree;
import jpt.sun.tools.javac.tree.TreeInfo;
import jpt.sun.tools.javac.tree.TreeScanner;
import jpt.sun.tools.javac.util.Constants;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.Log;
import jpt.sun.tools.javac.util.Name;
import jpt.sun.tools.javac.util.Names;
import jpt.sun.tools.javac.util.Pair;
import jpt30.lang.model.AnnotatedConstruct;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.AnnotationValue;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.util.ElementFilter;
import jpt30.lang.model.util.Elements;

public class JavacElements
implements Elements {
    private final JavaCompiler javaCompiler;
    private final Symtab syms;
    private final Modules modules;
    private final Names names;
    private final Types types;
    private final Enter enter;
    private final Resolve resolve;
    private final JavacTaskImpl javacTaskImpl;
    private final Log log;
    private final boolean allowModules;
    private final Set<String> alreadyWarnedDuplicates = new HashSet<String>();
    private final Map<Pair<String, String>, Optional<Symbol>> resultCache = new HashMap<Pair<String, String>, Optional<Symbol>>();

    public static JavacElements instance(Context context) {
        JavacElements instance = context.get(JavacElements.class);
        if (instance == null) {
            instance = new JavacElements(context);
        }
        return instance;
    }

    protected JavacElements(Context context) {
        JavacTaskImpl taskImpl;
        JavacTask t;
        context.put(JavacElements.class, this);
        this.javaCompiler = JavaCompiler.instance(context);
        this.syms = Symtab.instance(context);
        this.modules = Modules.instance(context);
        this.names = Names.instance(context);
        this.types = Types.instance(context);
        this.enter = Enter.instance(context);
        this.resolve = Resolve.instance(context);
        JavacTask javacTask = t = context.get(JavacTask.class);
        this.javacTaskImpl = javacTask instanceof JavacTaskImpl ? (taskImpl = (JavacTaskImpl)javacTask) : null;
        this.log = Log.instance(context);
        Source source = Source.instance(context);
        this.allowModules = Source.Feature.MODULES.allowedInSource(source);
    }

    @Override
    public Set<? extends ModuleElement> getAllModuleElements() {
        if (this.allowModules) {
            return Collections.unmodifiableSet(this.modules.allModules());
        }
        return Collections.emptySet();
    }

    @Override
    public Symbol.ModuleSymbol getModuleElement(CharSequence name) {
        this.ensureEntered("getModuleElement");
        if (this.modules.getDefaultModule() == this.syms.noModule) {
            return null;
        }
        String strName = name.toString();
        if (strName.equals("")) {
            return this.syms.unnamedModule;
        }
        return this.modules.getObservableModule(this.names.fromString(strName));
    }

    @Override
    public Symbol.PackageSymbol getPackageElement(CharSequence name) {
        return this.doGetPackageElement(null, name);
    }

    @Override
    public Symbol.PackageSymbol getPackageElement(ModuleElement module, CharSequence name) {
        module.getClass();
        return this.doGetPackageElement(module, name);
    }

    private Symbol.PackageSymbol doGetPackageElement(ModuleElement module, CharSequence name) {
        this.ensureEntered("getPackageElement");
        return this.doGetElement(module, "getPackageElement", name, Symbol.PackageSymbol.class);
    }

    @Override
    public Symbol.ClassSymbol getTypeElement(CharSequence name) {
        return this.doGetTypeElement(null, name);
    }

    @Override
    public Symbol.ClassSymbol getTypeElement(ModuleElement module, CharSequence name) {
        module.getClass();
        return this.doGetTypeElement(module, name);
    }

    private Symbol.ClassSymbol doGetTypeElement(ModuleElement module, CharSequence name) {
        this.ensureEntered("getTypeElement");
        return this.doGetElement(module, "getTypeElement", name, Symbol.ClassSymbol.class);
    }

    private <S extends Symbol> S doGetElement(ModuleElement module, String methodName, CharSequence name, Class<S> clazz) {
        String strName = name.toString();
        if (!(SourceVersion.isName(strName) || strName.isEmpty() && clazz != Symbol.ClassSymbol.class)) {
            return null;
        }
        if (module == null) {
            return this.unboundNameToSymbol(methodName, strName, clazz);
        }
        return this.nameToSymbol((Symbol.ModuleSymbol)module, strName, clazz);
    }

    private <S extends Symbol> S unboundNameToSymbol(String methodName, String nameStr, Class<S> clazz) {
        if (this.modules.getDefaultModule() == this.syms.noModule) {
            return this.nameToSymbol(this.syms.noModule, nameStr, clazz);
        }
        return (S)((Symbol)this.resultCache.computeIfAbsent(Pair.of(methodName, nameStr), p -> {
            LinkedHashSet found = new LinkedHashSet();
            HashSet<Symbol.ModuleSymbol> allModules = new HashSet<Symbol.ModuleSymbol>(this.modules.allModules());
            allModules.removeAll(this.modules.getRootModules());
            for (Set modules : Arrays.asList(this.modules.getRootModules(), allModules)) {
                for (Symbol.ModuleSymbol msym : modules) {
                    Object sym = this.nameToSymbol(msym, nameStr, clazz);
                    if (sym == null) continue;
                    if (clazz == Symbol.ClassSymbol.class) {
                        found.add(sym);
                        continue;
                    }
                    if (clazz != Symbol.PackageSymbol.class || ((Symbol)sym).members().isEmpty() && ((Symbol.PackageSymbol)sym).package_info == null) continue;
                    found.add(sym);
                }
                if (found.size() == 1) {
                    return Optional.of((Symbol)found.iterator().next());
                }
                if (found.size() <= 1) continue;
                if (this.alreadyWarnedDuplicates.add(methodName + ":" + nameStr)) {
                    String moduleNames = found.stream().map(s -> s.packge().modle).map(m -> m.toString()).collect(Collectors.joining(", "));
                    this.log.note(CompilerProperties.Notes.MultipleElements(methodName, nameStr, moduleNames));
                }
                return Optional.empty();
            }
            return Optional.empty();
        }).orElse(null));
    }

    private <S extends Symbol> S nameToSymbol(Symbol.ModuleSymbol module, String nameStr, Class<S> clazz) {
        Name name = this.names.fromString(nameStr);
        Symbol sym = clazz == Symbol.ClassSymbol.class ? this.syms.getClass(module, name) : this.syms.lookupPackage(module, name);
        try {
            if (sym == null) {
                sym = this.javaCompiler.resolveIdent(module, nameStr);
            }
            if (clazz.isInstance(sym)) {
                sym.complete();
                if (sym.kind != Kinds.Kind.ERR && sym.exists() && name.equals(sym.getQualifiedName())) {
                    return (S)((Symbol)clazz.cast(sym));
                }
            }
            return null;
        }
        catch (Symbol.CompletionFailure cf) {
            cf.dcfh.handleAPICompletionFailure(cf);
            return null;
        }
    }

    private JCTree matchAnnoToTree(AnnotationMirror findme, Element e, JCTree tree) {
        Symbol sym = JavacElements.cast(Symbol.class, e);
        class Vis
        extends JCTree.Visitor {
            List<JCTree.JCAnnotation> result = null;

            Vis() {
            }

            @Override
            public void visitModuleDef(JCTree.JCModuleDecl tree) {
                this.result = tree.mods.annotations;
            }

            @Override
            public void visitPackageDef(JCTree.JCPackageDecl tree) {
                this.result = tree.annotations;
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                this.result = tree.mods.annotations;
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl tree) {
                this.result = tree.mods.annotations;
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                this.result = tree.mods.annotations;
            }

            @Override
            public void visitTypeParameter(JCTree.JCTypeParameter tree) {
                this.result = tree.annotations;
            }
        }
        Vis vis = new Vis();
        tree.accept(vis);
        if (vis.result == null) {
            return null;
        }
        java.util.List annos = sym.getAnnotationMirrors();
        return this.matchAnnoToTree(JavacElements.cast(Attribute.Compound.class, findme), (List<Attribute.Compound>)annos, vis.result);
    }

    private JCTree matchAnnoToTree(Attribute.Compound findme, List<Attribute.Compound> annos, List<JCTree.JCAnnotation> trees) {
        for (Attribute.Compound anno : annos) {
            for (JCTree.JCAnnotation tree : trees) {
                JCTree match;
                if (tree.type.tsym != anno.type.tsym || (match = this.matchAttributeToTree(findme, anno, tree)) == null) continue;
                return match;
            }
        }
        return null;
    }

    private JCTree matchAttributeToTree(final Attribute findme, Attribute attr, final JCTree tree) {
        if (attr == findme) {
            return tree;
        }
        class Vis
        implements Attribute.Visitor {
            JCTree result = null;

            Vis() {
            }

            @Override
            public void visitConstant(Attribute.Constant value) {
            }

            @Override
            public void visitClass(Attribute.Class clazz) {
            }

            @Override
            public void visitCompound(Attribute.Compound anno) {
                for (Pair<Symbol.MethodSymbol, Attribute> pair : anno.values) {
                    JCTree match;
                    JCTree.JCExpression expr = JavacElements.this.scanForAssign((Symbol.MethodSymbol)pair.fst, tree);
                    if (expr == null || (match = JavacElements.this.matchAttributeToTree(findme, (Attribute)pair.snd, expr)) == null) continue;
                    this.result = match;
                    return;
                }
            }

            @Override
            public void visitArray(Attribute.Array array) {
                if (tree.hasTag(JCTree.Tag.NEWARRAY)) {
                    List<JCTree.JCExpression> elems = ((JCTree.JCNewArray)tree).elems;
                    for (Attribute value : array.values) {
                        JCTree match = JavacElements.this.matchAttributeToTree(findme, value, (JCTree)elems.head);
                        if (match != null) {
                            this.result = match;
                            return;
                        }
                        elems = elems.tail;
                    }
                } else if (array.values.length == 1) {
                    this.result = JavacElements.this.matchAttributeToTree(findme, array.values[0], tree);
                }
            }

            @Override
            public void visitEnum(Attribute.Enum e) {
            }

            @Override
            public void visitError(Attribute.Error e) {
            }
        }
        Vis vis = new Vis();
        attr.accept(vis);
        return vis.result;
    }

    private JCTree.JCExpression scanForAssign(final Symbol.MethodSymbol sym, final JCTree tree) {
        class TS
        extends TreeScanner {
            JCTree.JCExpression result = null;

            TS() {
            }

            @Override
            public void scan(JCTree t) {
                if (t != null && this.result == null) {
                    t.accept(this);
                }
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation t) {
                if (t == tree) {
                    this.scan(t.args);
                }
            }

            @Override
            public void visitAssign(JCTree.JCAssign t) {
                if (t.lhs.hasTag(JCTree.Tag.IDENT)) {
                    JCTree.JCIdent ident = (JCTree.JCIdent)t.lhs;
                    if (ident.sym == sym) {
                        this.result = t.rhs;
                    }
                }
            }
        }
        TS scanner = new TS();
        tree.accept(scanner);
        return scanner.result;
    }

    public JCTree getTree(Element e) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTop = this.getTreeAndTopLevel(e);
        return treeTop != null ? (JCTree)treeTop.fst : null;
    }

    @Override
    public String getDocComment(Element e) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTop = this.getTreeAndTopLevel(e);
        if (treeTop == null) {
            return null;
        }
        JCTree tree = (JCTree)treeTop.fst;
        JCTree.JCCompilationUnit toplevel = (JCTree.JCCompilationUnit)treeTop.snd;
        if (toplevel.docComments == null) {
            return null;
        }
        return toplevel.docComments.getCommentText(tree);
    }

    @Override
    public PackageElement getPackageOf(Element e) {
        if (e.getKind() == ElementKind.MODULE) {
            return null;
        }
        return JavacElements.cast(Symbol.class, e).packge();
    }

    @Override
    public ModuleElement getModuleOf(Element e) {
        Symbol sym = JavacElements.cast(Symbol.class, e);
        if (this.modules.getDefaultModule() == this.syms.noModule) {
            return null;
        }
        return sym.kind == Kinds.Kind.MDL ? (ModuleElement)e : sym.packge().modle;
    }

    @Override
    public boolean isDeprecated(Element e) {
        Symbol sym = JavacElements.cast(Symbol.class, e);
        sym.apiComplete();
        return sym.isDeprecated();
    }

    @Override
    public Elements.Origin getOrigin(Element e) {
        Symbol sym = JavacElements.cast(Symbol.class, e);
        if ((sym.flags() & 0x1000000000L) != 0L) {
            return Elements.Origin.MANDATED;
        }
        if ((sym.flags() & 0x8000L) != 0L) {
            return Elements.Origin.MANDATED;
        }
        return Elements.Origin.EXPLICIT;
    }

    @Override
    public Elements.Origin getOrigin(AnnotatedConstruct c, AnnotationMirror a) {
        Attribute.Compound ac = JavacElements.cast(Attribute.Compound.class, a);
        if (ac.isSynthesized()) {
            return Elements.Origin.MANDATED;
        }
        return Elements.Origin.EXPLICIT;
    }

    @Override
    public Elements.Origin getOrigin(ModuleElement m, ModuleElement.Directive directive) {
        switch (directive.getKind()) {
            case REQUIRES: {
                Directive.RequiresDirective rd = JavacElements.cast(Directive.RequiresDirective.class, directive);
                if (rd.flags.contains((Object)Directive.RequiresFlag.MANDATED)) {
                    return Elements.Origin.MANDATED;
                }
                if (rd.flags.contains((Object)Directive.RequiresFlag.SYNTHETIC)) {
                    return Elements.Origin.SYNTHETIC;
                }
                return Elements.Origin.EXPLICIT;
            }
            case EXPORTS: {
                Directive.ExportsDirective ed = JavacElements.cast(Directive.ExportsDirective.class, directive);
                if (ed.flags.contains((Object)Directive.ExportsFlag.MANDATED)) {
                    return Elements.Origin.MANDATED;
                }
                if (ed.flags.contains((Object)Directive.ExportsFlag.SYNTHETIC)) {
                    return Elements.Origin.SYNTHETIC;
                }
                return Elements.Origin.EXPLICIT;
            }
            case OPENS: {
                Directive.OpensDirective od = JavacElements.cast(Directive.OpensDirective.class, directive);
                if (od.flags.contains((Object)Directive.OpensFlag.MANDATED)) {
                    return Elements.Origin.MANDATED;
                }
                if (od.flags.contains((Object)Directive.OpensFlag.SYNTHETIC)) {
                    return Elements.Origin.SYNTHETIC;
                }
                return Elements.Origin.EXPLICIT;
            }
        }
        return Elements.Origin.EXPLICIT;
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        return JavacElements.cast(Symbol.TypeSymbol.class, type).flatName();
    }

    public Map<Symbol.MethodSymbol, Attribute> getElementValuesWithDefaults(AnnotationMirror a) {
        Attribute.Compound anno = JavacElements.cast(Attribute.Compound.class, a);
        DeclaredType annotype = a.getAnnotationType();
        Map<Symbol.MethodSymbol, Attribute> valmap = anno.getElementValues();
        for (ExecutableElement ex : ElementFilter.methodsIn(annotype.asElement().getEnclosedElements())) {
            Symbol.MethodSymbol meth = (Symbol.MethodSymbol)ex;
            Attribute defaultValue = meth.getDefaultValue();
            if (defaultValue == null || valmap.containsKey(meth)) continue;
            valmap.put(meth, defaultValue);
        }
        return valmap;
    }

    public FilteredMemberList getAllMembers(TypeElement element) {
        Symbol sym = JavacElements.cast(Symbol.class, element);
        Scope.WriteableScope scope = sym.members().dupUnshared();
        List<Type> closure = this.types.closure(sym.asType());
        for (Type t : closure) {
            this.addMembers(scope, t);
        }
        return new FilteredMemberList(scope);
    }

    private void addMembers(Scope.WriteableScope scope, Type type) {
        block0: for (Symbol e : type.asElement().members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            boolean initializer;
            for (Symbol overrider : scope.getSymbolsByName(e.getSimpleName())) {
                if (overrider.kind != e.kind || (overrider.flags() & 0x1000L) != 0L || overrider.getKind() != ElementKind.METHOD || !this.overrides((ExecutableElement)((Object)overrider), (ExecutableElement)((Object)e), (TypeElement)((Object)type.asElement()))) continue;
                continue block0;
            }
            boolean derived = e.getEnclosingElement() != scope.owner;
            ElementKind kind = e.getKind();
            boolean bl = initializer = kind == ElementKind.CONSTRUCTOR || kind == ElementKind.INSTANCE_INIT || kind == ElementKind.STATIC_INIT;
            if (derived && (initializer || !e.isInheritedIn(scope.owner, this.types))) continue;
            scope.enter(e);
        }
    }

    public List<Attribute.Compound> getAllAnnotationMirrors(Element e) {
        Type sup;
        Symbol sym = JavacElements.cast(Symbol.class, e);
        List<Attribute.Compound> annos = sym.getAnnotationMirrors();
        while (sym.getKind() == ElementKind.CLASS && (sup = ((Symbol.ClassSymbol)sym).getSuperclass()).hasTag(TypeTag.CLASS) && !sup.isErroneous() && sup.tsym != this.syms.objectType.tsym) {
            sym = sup.tsym;
            List<Attribute.Compound> oldAnnos = annos;
            java.util.List newAnnos = sym.getAnnotationMirrors();
            for (Attribute.Compound anno : newAnnos) {
                if (!this.isInherited(anno.type) || JavacElements.containsAnnoOfType(oldAnnos, anno.type)) continue;
                annos = annos.prepend(anno);
            }
        }
        return annos;
    }

    private boolean isInherited(Type annotype) {
        return annotype.tsym.attribute(this.syms.inheritedType.tsym) != null;
    }

    private static boolean containsAnnoOfType(List<Attribute.Compound> annos, Type type) {
        for (Attribute.Compound anno : annos) {
            if (anno.type.tsym != type.tsym) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hides(Element hiderEl, Element hideeEl) {
        Symbol hidee;
        Symbol hider = JavacElements.cast(Symbol.class, hiderEl);
        if (hider == (hidee = JavacElements.cast(Symbol.class, hideeEl)) || hider.kind != hidee.kind || hider.name != hidee.name) {
            return false;
        }
        if (!(hider.kind != Kinds.Kind.MTH || hider.isStatic() && this.types.isSubSignature(hider.type, hidee.type))) {
            return false;
        }
        Symbol.ClassSymbol hiderClass = hider.owner.enclClass();
        Symbol.ClassSymbol hideeClass = hidee.owner.enclClass();
        if (hiderClass == null || hideeClass == null || !hiderClass.isSubClass(hideeClass, this.types)) {
            return false;
        }
        return hidee.isAccessibleIn(hiderClass, this.types);
    }

    @Override
    public boolean overrides(ExecutableElement riderEl, ExecutableElement rideeEl, TypeElement typeEl) {
        Symbol.MethodSymbol rider = JavacElements.cast(Symbol.MethodSymbol.class, riderEl);
        Symbol.MethodSymbol ridee = JavacElements.cast(Symbol.MethodSymbol.class, rideeEl);
        Symbol.ClassSymbol origin = JavacElements.cast(Symbol.ClassSymbol.class, typeEl);
        return rider.name == ridee.name && rider != ridee && !rider.isStatic() && ridee.isMemberOf(origin, this.types) && rider.overrides(ridee, origin, this.types, false);
    }

    @Override
    public String getConstantExpression(Object value) {
        return Constants.format(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        for (Element element : elements) {
            ((PrintingProcessor.PrintingElementVisitor)new PrintingProcessor.PrintingElementVisitor(w, this).visit(element)).flush();
        }
    }

    @Override
    public Name getName(CharSequence cs) {
        return this.names.fromString(cs.toString());
    }

    @Override
    public boolean isFunctionalInterface(TypeElement element) {
        if (element.getKind() != ElementKind.INTERFACE) {
            return false;
        }
        Symbol.TypeSymbol tsym = JavacElements.cast(Symbol.TypeSymbol.class, element);
        return this.types.isFunctionalInterface(tsym);
    }

    @Override
    public boolean isAutomaticModule(ModuleElement module) {
        Symbol.ModuleSymbol msym = (Symbol.ModuleSymbol)module;
        return (msym.flags() & 0x10000000000000L) != 0L;
    }

    private Pair<JCTree, JCTree.JCCompilationUnit> getTreeAndTopLevel(Element e) {
        Symbol sym = JavacElements.cast(Symbol.class, e);
        Env<AttrContext> enterEnv = this.getEnterEnv(sym);
        if (enterEnv == null) {
            return null;
        }
        JCTree tree = TreeInfo.declarationFor(sym, enterEnv.tree);
        if (tree == null || enterEnv.toplevel == null) {
            return null;
        }
        return new Pair<JCTree, JCTree.JCCompilationUnit>(tree, enterEnv.toplevel);
    }

    public Pair<JCTree, JCTree.JCCompilationUnit> getTreeAndTopLevel(Element e, AnnotationMirror a, AnnotationValue v) {
        if (e == null) {
            return null;
        }
        Pair<JCTree, JCTree.JCCompilationUnit> elemTreeTop = this.getTreeAndTopLevel(e);
        if (elemTreeTop == null) {
            return null;
        }
        if (a == null) {
            return elemTreeTop;
        }
        JCTree annoTree = this.matchAnnoToTree(a, e, (JCTree)elemTreeTop.fst);
        if (annoTree == null) {
            return elemTreeTop;
        }
        if (v == null) {
            return new Pair<JCTree, JCTree.JCCompilationUnit>(annoTree, (JCTree.JCCompilationUnit)elemTreeTop.snd);
        }
        JCTree valueTree = this.matchAttributeToTree(JavacElements.cast(Attribute.class, v), JavacElements.cast(Attribute.class, a), annoTree);
        if (valueTree == null) {
            return new Pair<JCTree, JCTree.JCCompilationUnit>(annoTree, (JCTree.JCCompilationUnit)elemTreeTop.snd);
        }
        return new Pair<JCTree, JCTree.JCCompilationUnit>(valueTree, (JCTree.JCCompilationUnit)elemTreeTop.snd);
    }

    private Env<AttrContext> getEnterEnv(Symbol sym) {
        Symbol.TypeSymbol ts = null;
        switch (sym.kind) {
            case PCK: {
                ts = (Symbol.PackageSymbol)sym;
                break;
            }
            case MDL: {
                ts = (Symbol.ModuleSymbol)sym;
                break;
            }
            default: {
                ts = sym.enclClass();
            }
        }
        return ts != null ? this.enter.getEnv(ts) : null;
    }

    private void ensureEntered(String methodName) {
        if (this.javacTaskImpl != null) {
            this.javacTaskImpl.ensureEntered();
        }
        if (!this.javaCompiler.isEnterDone()) {
            throw new IllegalStateException("Cannot use Elements." + methodName + " before the TaskEvent.Kind.ENTER finished event.");
        }
    }

    private static <T> T cast(Class<T> clazz, Object o) {
        if (!clazz.isInstance(o)) {
            throw new IllegalArgumentException(o.toString());
        }
        return clazz.cast(o);
    }

    public void newRound() {
        this.resultCache.clear();
    }
}

