/*
 * Decompiled with CFR 0.152.
 */
package jpt30.annotation.processing;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jpt30.annotation.processing.Completion;
import jpt30.annotation.processing.ProcessingEnvironment;
import jpt30.annotation.processing.Processor;
import jpt30.annotation.processing.RoundEnvironment;
import jpt30.annotation.processing.SupportedAnnotationTypes;
import jpt30.annotation.processing.SupportedOptions;
import jpt30.annotation.processing.SupportedSourceVersion;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.tools.Diagnostic;

public abstract class AbstractProcessor
implements Processor {
    protected ProcessingEnvironment processingEnv;
    private boolean initialized = false;

    protected AbstractProcessor() {
    }

    @Override
    public Set<String> getSupportedOptions() {
        SupportedOptions so = this.getClass().getAnnotation(SupportedOptions.class);
        return so == null ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(new String[0]))) : this.arrayToSet(so.value(), false, "option value", "@SupportedOptions");
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        SupportedAnnotationTypes sat = this.getClass().getAnnotation(SupportedAnnotationTypes.class);
        boolean initialized = this.isInitialized();
        if (sat == null) {
            if (initialized) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No SupportedAnnotationTypes annotation found on " + this.getClass().getName() + ", returning an empty set.");
            }
            return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(new String[0])));
        }
        boolean stripModulePrefixes = initialized && this.processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_8) <= 0;
        return this.arrayToSet(sat.value(), stripModulePrefixes, "annotation type", "@SupportedAnnotationTypes");
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SupportedSourceVersion ssv = this.getClass().getAnnotation(SupportedSourceVersion.class);
        SourceVersion sv = null;
        if (ssv == null) {
            sv = SourceVersion.RELEASE_6;
            if (this.isInitialized()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No SupportedSourceVersion annotation found on " + this.getClass().getName() + ", returning " + (Object)((Object)sv) + ".");
            }
        } else {
            sv = ssv.value();
        }
        return sv;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot call init more than once.");
        }
        Objects.requireNonNull(processingEnv, "Tool provided null ProcessingEnvironment");
        this.processingEnv = processingEnv;
        this.initialized = true;
    }

    @Override
    public abstract boolean process(Set<? extends TypeElement> var1, RoundEnvironment var2);

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.unmodifiableList(Arrays.asList(new Completion[0]));
    }

    protected synchronized boolean isInitialized() {
        return this.initialized;
    }

    private Set<String> arrayToSet(String[] array, boolean stripModulePrefixes, String contentType, String annotationName) {
        assert (array != null);
        HashSet<String> set = new HashSet<String>();
        for (String s : array) {
            boolean added;
            int index;
            boolean stripped = false;
            if (stripModulePrefixes && (index = s.indexOf(47)) != -1) {
                s = s.substring(index + 1);
                stripped = true;
            }
            if ((added = set.add(s)) || stripped || !this.isInitialized()) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Duplicate " + contentType + " ``" + s + "'' for processor " + this.getClass().getName() + " in its " + annotationName + "annotation.");
        }
        return Collections.unmodifiableSet(set);
    }
}

