/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.ui.SettingsTab;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;

public class SettingsTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAME_KEYS = new String[]{"SettingsTable_ActiveColumn", "SettingsTable_NameColumn"};
    private static final Class[] COLUMN_TYPES = new Class[]{Boolean.class, UpdateUnitProvider.class};
    private List<UpdateUnitProvider> updateProviders;
    private Set<String> originalProviders;
    private SettingsTab settingsTab = null;

    public SettingsTableModel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SettingsTableModel.this.refreshModel();
            }
        });
    }

    void setSettingsTab(SettingsTab settingsTab) {
        this.settingsTab = settingsTab;
    }

    SettingsTab getSettingsTab() {
        return this.settingsTab;
    }

    void refreshModel() {
        Set<String> oldValue = this.originalProviders;
        HashSet<String> newValue = new HashSet<String>();
        final ArrayList<UpdateUnitProvider> forRefresh = new ArrayList<UpdateUnitProvider>();
        List<UpdateUnitProvider> providers = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false);
        for (UpdateUnitProvider p : providers) {
            if (oldValue != null && !oldValue.contains(p.getName()) && p.isEnabled()) {
                forRefresh.add(p);
            }
            newValue.add(p.getName());
        }
        if (!forRefresh.isEmpty()) {
            this.getSettingsTab().setWaitingState(true);
            Utilities.startAsWorkerThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Utilities.presentRefreshProviders(forRefresh, SettingsTableModel.this.getSettingsTab().getPluginManager(), true);
                        SettingsTableModel.this.getSettingsTab().getPluginManager().updateUnitsChanged();
                    }
                    finally {
                        SettingsTableModel.this.getSettingsTab().setWaitingState(false);
                    }
                }
            });
        }
        if (oldValue != null && !oldValue.isEmpty() && !newValue.containsAll(oldValue)) {
            this.getSettingsTab().setNeedRefresh();
        }
        this.updateProviders = new ArrayList<UpdateUnitProvider>();
        for (UpdateUnitProvider p : providers) {
            if (p.getDisplayName() == null) continue;
            this.updateProviders.add(p);
        }
        this.originalProviders = newValue;
        SettingsTableModel.sortAlphabetically(this.updateProviders);
        this.fireTableDataChanged();
    }

    public void remove(int rowIndex) {
        UpdateUnitProvider unitProvider = this.getUpdateUnitProvider(rowIndex);
        if (unitProvider != null) {
            UpdateUnitProviderFactory.getDefault().remove(unitProvider);
        }
        this.getSettingsTab().setNeedRefresh();
    }

    public void add(String name, String displayName, URL url, boolean state) {
        UpdateUnitProvider uup = UpdateUnitProviderFactory.getDefault().create(name, displayName, url);
        uup.setEnable(state);
    }

    public UpdateUnitProvider getUpdateUnitProvider(int rowIndex) {
        return rowIndex >= 0 && rowIndex < this.updateProviders.size() ? this.updateProviders.get(rowIndex) : null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public int getRowCount() {
        return this.updateProviders == null ? 0 : this.updateProviders.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAME_KEYS.length;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        UpdateUnitProvider unitProvider = this.getUpdateUnitProvider(rowIndex);
        switch (columnIndex) {
            case 0: {
                boolean oldValue = unitProvider.isEnabled();
                boolean newValue = (Boolean)aValue;
                if (oldValue == newValue) break;
                unitProvider.setEnable(newValue);
                if (newValue) {
                    this.getSettingsTab().refreshProvider(unitProvider, false);
                    break;
                }
                this.getSettingsTab().refreshProvider(unitProvider, false);
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object retval = null;
        UpdateUnitProvider unitProvider = this.updateProviders.get(rowIndex);
        if (unitProvider == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                retval = unitProvider.isEnabled();
                break;
            }
            case 1: {
                retval = unitProvider;
            }
        }
        return retval;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public String getColumnName(int columnIndex) {
        return NbBundle.getMessage(SettingsTableModel.class, COLUMN_NAME_KEYS[columnIndex]);
    }

    private static void sortAlphabetically(List<UpdateUnitProvider> res) {
        Collections.sort(res, new Comparator<UpdateUnitProvider>(){

            @Override
            public int compare(UpdateUnitProvider p1, UpdateUnitProvider p2) {
                return p1.getDisplayName().compareTo(p2.getDisplayName());
            }
        });
    }
}

