/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt30.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.PrefetchableJavaFileObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;

public class FolderArchive
implements Archive {
    private static final Logger LOG = Logger.getLogger(FolderArchive.class.getName());
    private static final boolean normalize = Boolean.getBoolean("FolderArchive.normalize");
    final File root;
    volatile Charset encoding;
    private boolean sourceRootInitialized;
    private URL sourceRoot;
    private static final Charset UNKNOWN_CHARSET = new Charset("UNKNOWN", null){

        @Override
        public boolean contains(Charset cs) {
            throw new UnsupportedOperationException("Unexpected call");
        }

        @Override
        public CharsetDecoder newDecoder() {
            throw new UnsupportedOperationException("Unexpected call");
        }

        @Override
        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException("Unexpected call");
        }
    };

    public FolderArchive(File root) {
        assert (root != null);
        this.root = root;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "creating FolderArchive for {0}", root.getAbsolutePath());
        }
    }

    private Charset encoding() {
        Charset e = this.encoding;
        if (e == null) {
            FileObject file = FileUtil.toFileObject(this.root);
            e = file != null ? FileEncodingQuery.getEncoding(file) : UNKNOWN_CHARSET;
            this.encoding = e;
        }
        return e != UNKNOWN_CHARSET ? e : null;
    }

    @Override
    public Iterable<JavaFileObject> getFiles(@NonNull String folderName, @NullAllowed ClassPath.Entry entry, @NullAllowed Set<JavaFileObject.Kind> kinds, @NullAllowed JavaFileFilterImplementation filter, boolean recursive) throws IOException {
        assert (folderName != null);
        if (folderName.length() > 0) {
            folderName = folderName + '/';
        }
        if (entry == null || entry.includes(folderName)) {
            File folder = new File(this.root, folderName.replace('/', File.separatorChar));
            if (normalize) {
                folder = FileUtil.normalizeFile(folder);
            }
            return FolderArchive.visit(folder, this.root, this.encoding(), filter, recursive, f -> {
                JavaFileObject.Kind fKind = FileObjects.getKind(FileObjects.getExtension(f.getName()));
                try {
                    if ((kinds == null || kinds.contains((Object)fKind)) && f.isFile() && (entry == null || entry.includes(BaseUtilities.toURI(f).toURL()))) {
                        return fKind;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return null;
            });
        }
        return Collections.emptyList();
    }

    @Override
    public JavaFileObject create(String relativePath, JavaFileFilterImplementation filter) throws UnsupportedOperationException {
        if (File.separatorChar != '/') {
            relativePath = relativePath.replace('/', File.separatorChar);
        }
        File file = new File(this.root, relativePath);
        return FileObjects.fileFileObject(file, this.root, filter, this.encoding());
    }

    @Override
    public void clear() {
    }

    @Override
    public JavaFileObject getFile(@NonNull String name) {
        String path = name.replace('/', File.separatorChar);
        File file = new File(this.root, path);
        if (file.exists()) {
            return FileObjects.fileFileObject(file, this.root, null, this.encoding());
        }
        try {
            URL srcRoot = this.getBaseSourceRoot(BaseUtilities.toURI(this.root).toURL());
            if (srcRoot != null && JavaIndex.hasSourceCache(srcRoot, false)) {
                if ("file".equals(srcRoot.getProtocol())) {
                    File folder = BaseUtilities.toFile(srcRoot.toURI());
                    file = new File(folder, path);
                    if (file.exists()) {
                        return FileObjects.fileFileObject(file, folder, null, this.encoding());
                    }
                } else {
                    FileObject resource;
                    FileObject srcRootFo = URLMapper.findFileObject(srcRoot);
                    if (srcRootFo != null && (resource = srcRootFo.getFileObject(name)) != null) {
                        return FileObjects.sourceFileObject(resource, srcRootFo);
                    }
                }
            } else {
                LOG.log(Level.FINE, "No source in: {0}.", srcRoot);
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace(e);
        }
        catch (URISyntaxException e) {
            Exceptions.printStackTrace(e);
        }
        return null;
    }

    public String toString() {
        return String.format("%s[folder: %s]", this.getClass().getSimpleName(), this.root.getAbsolutePath());
    }

    @Override
    public boolean isMultiRelease() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getBaseSourceRoot(URL binRoot) {
        FolderArchive folderArchive = this;
        synchronized (folderArchive) {
            if (this.sourceRootInitialized) {
                return this.sourceRoot;
            }
        }
        URL tmpSourceRoot = JavaIndex.getSourceRootForClassFolder(binRoot);
        FolderArchive folderArchive2 = this;
        synchronized (folderArchive2) {
            this.sourceRoot = tmpSourceRoot;
            this.sourceRootInitialized = true;
            return this.sourceRoot;
        }
    }

    @NonNull
    private static List<JavaFileObject> visit(@NonNull File folder, @NonNull File root, @NonNull Charset encoding, @NullAllowed JavaFileFilterImplementation filter, boolean recursive, @NonNull Function<File, JavaFileObject.Kind> accept) {
        ArrayList<PrefetchableJavaFileObject> res = new ArrayList<PrefetchableJavaFileObject>();
        ArrayDeque<File> todo = new ArrayDeque<File>();
        todo.offer(folder);
        while (!todo.isEmpty()) {
            File active = (File)todo.removeLast();
            File[] content = active.listFiles();
            if (content == null) continue;
            for (File f : content) {
                JavaFileObject.Kind fKind = accept.apply(f);
                if (fKind != null) {
                    res.add(FileObjects.fileFileObject(f, root, filter, fKind == JavaFileObject.Kind.CLASS ? UNKNOWN_CHARSET : encoding));
                    continue;
                }
                if (!recursive || !f.isDirectory()) continue;
                todo.offer(f);
            }
        }
        return Collections.unmodifiableList(res);
    }
}

