/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage;

import java.nio.file.Path;
import java.util.Objects;

public final class Option<T> {
    private final String key;
    private final Class<T> type;
    private final String defaultValue;
    private final Parser<? extends T> parser;
    private final String comment;
    private final Status status;

    private Option(String key, Class<T> type, String defaultValue, Parser<? extends T> parser, String comment) {
        this(key, type, defaultValue, parser, comment, Status.NORMAL);
    }

    private Option(String key, Class<T> type, String defaultValue, Parser<? extends T> parser, String comment, Status status) {
        this.key = Objects.requireNonNull(key);
        this.type = Objects.requireNonNull(type);
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.parser = Objects.requireNonNull(parser);
        this.comment = Objects.requireNonNull(comment);
        this.status = Objects.requireNonNull(status);
    }

    public String key() {
        return this.key;
    }

    public Class<T> type() {
        return this.type;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public T parse(String text) throws Exception {
        return this.parser.parse(text);
    }

    public String comment() {
        return this.comment;
    }

    public Status status() {
        return this.status;
    }

    public Option<T> withStatus(Status status) {
        return new Option<T>(this.key, this.type, this.defaultValue, this.parser, this.comment, status);
    }

    public static Option<String> ofString(String key, String comment) {
        return Option.ofString(key, "", comment);
    }

    public static Option<String> ofString(String key, String defaultValue, String comment) {
        return new Option<String>(key, String.class, defaultValue, s -> s, comment);
    }

    public static Option<Path> ofPath(String key, String comment) {
        return Option.ofPath(key, "", comment);
    }

    public static Option<Path> ofPath(String key, String defaultValue, String comment) {
        return new Option<Path>(key, Path.class, defaultValue, s -> Path.of(s, new String[0]), comment);
    }

    public static <T> Option<T> of(String key, Class<T> type, String defaultValue, Parser<? extends T> parser, String comment) {
        return new Option<T>(key, type, defaultValue, parser, comment);
    }

    public static enum Status {
        NORMAL,
        DEPRECATED,
        ADVANCED;

    }

    @FunctionalInterface
    public static interface Parser<T> {
        public T parse(String var1) throws Exception;
    }
}

