/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeException;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeNotifier;
import org.apache.nifi.minifi.bootstrap.configuration.ListenerHandleResult;
import org.apache.nifi.minifi.bootstrap.configuration.ingestors.interfaces.ChangeIngestor;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.util.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationChangeCoordinator
implements Closeable,
ConfigurationChangeNotifier {
    public static final String NOTIFIER_PROPERTY_PREFIX = "nifi.minifi.notifier";
    public static final String NOTIFIER_INGESTORS_KEY = "nifi.minifi.notifier.ingestors";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationChangeCoordinator.class);
    private final Set<ConfigurationChangeListener> configurationChangeListeners;
    private final Set<ChangeIngestor> changeIngestors = new HashSet<ChangeIngestor>();
    private final BootstrapFileProvider bootstrapFileProvider;
    private final RunMiNiFi runMiNiFi;

    public ConfigurationChangeCoordinator(BootstrapFileProvider bootstrapFileProvider, RunMiNiFi runMiNiFi, Set<ConfigurationChangeListener> miNiFiConfigurationChangeListeners) {
        this.bootstrapFileProvider = bootstrapFileProvider;
        this.runMiNiFi = runMiNiFi;
        this.configurationChangeListeners = Optional.ofNullable(miNiFiConfigurationChangeListeners).map(Collections::unmodifiableSet).orElse(Collections.emptySet());
    }

    public void start() throws IOException {
        this.initialize();
        this.changeIngestors.forEach(ChangeIngestor::start);
    }

    @Override
    public Set<ConfigurationChangeListener> getChangeListeners() {
        return Collections.unmodifiableSet(this.configurationChangeListeners);
    }

    @Override
    public Collection<ListenerHandleResult> notifyListeners(ByteBuffer newConfig) {
        LOGGER.info("Notifying Listeners of a change");
        ArrayList<ListenerHandleResult> listenerHandleResults = new ArrayList<ListenerHandleResult>(this.configurationChangeListeners.size());
        for (ConfigurationChangeListener listener : this.getChangeListeners()) {
            ListenerHandleResult result;
            try {
                listener.handleChange(new ByteBufferInputStream(newConfig.duplicate()));
                result = new ListenerHandleResult(listener);
            }
            catch (ConfigurationChangeException ex) {
                result = new ListenerHandleResult(listener, ex);
            }
            listenerHandleResults.add(result);
            LOGGER.info("Listener notification result: {}", (Object)result);
        }
        return listenerHandleResults;
    }

    @Override
    public void close() {
        try {
            for (ChangeIngestor changeIngestor : this.changeIngestors) {
                changeIngestor.close();
            }
            this.changeIngestors.clear();
        }
        catch (IOException e) {
            LOGGER.warn("Could not successfully stop notifiers", (Throwable)e);
        }
    }

    private void initialize() throws IOException {
        this.close();
        Properties bootstrapProperties = this.bootstrapFileProvider.getBootstrapProperties();
        String ingestorsCsv = bootstrapProperties.getProperty(NOTIFIER_INGESTORS_KEY);
        if (ingestorsCsv != null && !ingestorsCsv.isEmpty()) {
            for (String ingestorClassname : ingestorsCsv.split(",")) {
                ingestorClassname = ingestorClassname.trim();
                try {
                    Class<?> ingestorClass = Class.forName(ingestorClassname);
                    ChangeIngestor changeIngestor = (ChangeIngestor)ingestorClass.newInstance();
                    changeIngestor.initialize(bootstrapProperties, this.runMiNiFi, this);
                    this.changeIngestors.add(changeIngestor);
                    LOGGER.info("Initialized ingestor: {}", (Object)ingestorClassname);
                }
                catch (Exception e) {
                    LOGGER.error("Instantiating [{}] ingestor failed", (Object)ingestorClassname, (Object)e);
                }
            }
        }
    }
}

