/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.status;

import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.minifi.bootstrap.QueryableStatusAggregator;

public abstract class PeriodicStatusReporter {
    private ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
    private volatile int period = -1;
    private volatile int termination_wait = 5000;
    public volatile Runnable reportRunner;

    public abstract void initialize(Properties var1, QueryableStatusAggregator var2);

    public void start() {
        if (this.reportRunner == null) {
            throw new IllegalStateException("Programmatic error, the reportRunner is still NULL when 'start' was called.");
        }
        this.scheduledExecutorService.scheduleAtFixedRate(this.reportRunner, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        try {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService.awaitTermination(this.termination_wait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getTermination_wait() {
        return this.termination_wait;
    }

    public void setTermination_wait(int termination_wait) {
        this.termination_wait = termination_wait;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }
}

