/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.provider.nifi.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.nifi.minifi.c2.api.ConfigurationProviderException;
import org.apache.nifi.minifi.c2.api.util.Pair;
import org.apache.nifi.minifi.c2.provider.nifi.rest.TemplatesIteratorException;
import org.apache.nifi.minifi.c2.provider.util.HttpConnector;

public class TemplatesIterator
implements Iterator<Pair<String, String>>,
Closeable {
    public static final String FLOW_TEMPLATES = "/flow/templates";
    private final HttpURLConnection urlConnection;
    private final InputStream inputStream;
    private final JsonParser parser;
    private Pair<String, String> next;

    public TemplatesIterator(HttpConnector httpConnector, JsonFactory jsonFactory) throws ConfigurationProviderException, IOException {
        this.urlConnection = httpConnector.get(FLOW_TEMPLATES);
        this.inputStream = this.urlConnection.getInputStream();
        this.parser = jsonFactory.createParser(this.inputStream);
        while (this.parser.nextToken() != JsonToken.END_OBJECT && !"templates".equals(this.parser.getCurrentName())) {
        }
        this.next = this.getNext();
    }

    private Pair<String, String> getNext() throws IOException {
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            if (!"template".equals(this.parser.getCurrentName())) continue;
            String id = null;
            String name = null;
            while (this.parser.nextToken() != JsonToken.END_OBJECT) {
                String currentName = this.parser.getCurrentName();
                if ("id".equals(currentName)) {
                    this.parser.nextToken();
                    id = this.parser.getText();
                    continue;
                }
                if (!"name".equals(currentName)) continue;
                this.parser.nextToken();
                name = this.parser.getText();
            }
            return new Pair(id, name);
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Pair<String, String> next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        try {
            Pair<String, String> pair = this.next;
            return pair;
        }
        finally {
            try {
                this.next = this.getNext();
            }
            catch (IOException e) {
                throw new TemplatesIteratorException(e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            try {
                this.parser.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.urlConnection != null) {
            this.urlConnection.disconnect();
        }
    }
}

