/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.NoSuchElementException;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import org.jetbrains.annotations.NotNull;

public class ExcludeNullIterableDecorator
extends EntityIterableDecoratorBase {
    public ExcludeNullIterableDecorator(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source) {
        super(txn, source);
    }

    public static EntityIterableType getType() {
        return EntityIterableType.EXCLUDE_NULL;
    }

    @Override
    public boolean isSortedById() {
        return this.source.isSortedById();
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntityIteratorBase(this){
            private final EntityIterator iterator;
            private EntityId next;
            {
                this.iterator = ExcludeNullIterableDecorator.this.getDecorated().iterator();
                this.next = null;
            }

            @Override
            public boolean hasNextImpl() {
                if (this.next != null) {
                    return true;
                }
                while (this.iterator.hasNext() && this.next == null) {
                    this.next = this.iterator.nextId();
                }
                return this.next != null;
            }

            @Override
            public EntityId nextIdImpl() {
                if (this.hasNext()) {
                    EntityId result = this.next;
                    this.next = null;
                    return result;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), ExcludeNullIterableDecorator.getType(), this.source.getHandle()){

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                this.applyDecoratedToBuilder(builder);
            }
        };
    }

    static {
        ExcludeNullIterableDecorator.registerType(ExcludeNullIterableDecorator.getType(), (txn, store, parameters) -> new ExcludeNullIterableDecorator(txn, (EntityIterableBase)parameters[0]));
    }
}

