/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.shell.result;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.nifi.diagnostics.bootstrap.shell.result.ShellCommandResult;

public class SingleLineResult
implements ShellCommandResult {
    private final String label;
    private final String commandName;

    public SingleLineResult(String label, String commandName) {
        this.label = label;
        this.commandName = commandName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> createResult(InputStream inputStream) {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                result.add(String.format("%s : %s", this.label, line));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to process result for command: %s", this.commandName), e);
        }
    }
}

