/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicLong;

public class PrefixedTxIDCurrentFunctionFactory
implements FunctionFactory {
    private static final AtomicLong PG_TX_ID = new AtomicLong();
    private static final String SIGNATURE = "pg_catalog.txid_current()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new LongFunction(){

            @Override
            public long getLong(Record rec) {
                return PG_TX_ID.incrementAndGet();
            }

            @Override
            public void toPlan(PlanSink sink) {
                sink.val(PrefixedTxIDCurrentFunctionFactory.SIGNATURE);
            }
        };
    }
}

