/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.extension.ExtensionMetadata;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class ExtensionMetadataResult
extends AbstractWritableResult<List<ExtensionMetadata>> {
    private List<ExtensionMetadata> extensionMetadata;

    public ExtensionMetadataResult(ResultType resultType, List<ExtensionMetadata> extensionMetadata) {
        super(resultType);
        this.extensionMetadata = Objects.requireNonNull(extensionMetadata);
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        if (this.extensionMetadata.isEmpty()) {
            return;
        }
        Table table = new Table.Builder().column("Name", 20, 100, false).column("Bucket", 20, 200, false).column("Group", 20, 200, false).column("Artifact", 20, 200, false).column("Version", 8, 40, false).build();
        for (int i = 0; i < this.extensionMetadata.size(); ++i) {
            ExtensionMetadata metadata = this.extensionMetadata.get(i);
            table.addRow(metadata.getDisplayName(), metadata.getBundleInfo().getBucketName(), metadata.getBundleInfo().getGroupId(), metadata.getBundleInfo().getArtifactId(), metadata.getBundleInfo().getVersion());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public List<ExtensionMetadata> getResult() {
        return this.extensionMetadata;
    }
}

