/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.processing.stream;

import java.util.Objects;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.XMLEventReaderProvider;

public class StandardXMLEventReaderProvider
implements XMLEventReaderProvider {
    @Override
    public XMLEventReader getEventReader(StreamSource streamSource) {
        Objects.requireNonNull(streamSource, "StreamSource required");
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            return inputFactory.createXMLEventReader(streamSource);
        }
        catch (XMLStreamException e) {
            throw new ProcessingException("Reader creation failed", e);
        }
    }
}

