/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;

@XmlType(name="versionControlInformation")
public class VersionControlInformationDTO {
    public static final String LOCALLY_MODIFIED = "LOCALLY_MODIFIED";
    public static final String STALE = "STALE";
    public static final String LOCALLY_MODIFIED_AND_STALE = "LOCALLY_MODIFIED_AND_STALE";
    public static final String UP_TO_DATE = "UP_TO_DATE";
    public static final String SYNC_FAILURE = "SYNC_FAILURE";
    private static final String ALLOWABLE_STATES = String.join((CharSequence)", ", "LOCALLY_MODIFIED", "STALE", "LOCALLY_MODIFIED_AND_STALE", "UP_TO_DATE", "SYNC_FAILURE");
    private String groupId;
    private String registryId;
    private String registryName;
    private String branch;
    private String bucketId;
    private String bucketName;
    private String flowId;
    private String flowName;
    private String flowDescription;
    private String version;
    private String storageLocation;
    private String state;
    private String stateExplanation;

    @Schema(description="The ID of the Process Group that is under version control")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Schema(description="The ID of the registry that the flow is stored in")
    public String getRegistryId() {
        return this.registryId;
    }

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    @Schema(description="The name of the registry that the flow is stored in", accessMode=Schema.AccessMode.READ_ONLY)
    public String getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }

    @Schema(description="The ID of the branch that the flow is stored in")
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Schema(description="The ID of the bucket that the flow is stored in")
    public String getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(String bucketId) {
        this.bucketId = bucketId;
    }

    @Schema(description="The name of the bucket that the flow is stored in", accessMode=Schema.AccessMode.READ_ONLY)
    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Schema(description="The ID of the flow")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    @Schema(description="The name of the flow")
    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    @Schema(description="The description of the flow")
    public String getFlowDescription() {
        return this.flowDescription;
    }

    public void setFlowDescription(String flowDescription) {
        this.flowDescription = flowDescription;
    }

    @Schema(description="The version of the flow")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Schema(description="The storage location")
    public String getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="The current state of the Process Group, as it relates to the Versioned Flow", allowableValues={"LOCALLY_MODIFIED", "STALE", "LOCALLY_MODIFIED_AND_STALE", "UP_TO_DATE", "SYNC_FAILURE"})
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Schema(description="Explanation of why the group is in the specified state", accessMode=Schema.AccessMode.READ_ONLY)
    public String getStateExplanation() {
        return this.stateExplanation;
    }

    public void setStateExplanation(String explanation) {
        this.stateExplanation = explanation;
    }
}

