/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.annotations.AnnotationsForNavigationProperty;
import org.apache.olingo.ext.proxy.api.annotations.AnnotationsForProperty;
import org.apache.olingo.ext.proxy.commons.AbstractInvocationHandler;
import org.apache.olingo.ext.proxy.commons.AbstractStructuredInvocationHandler;
import org.apache.olingo.ext.proxy.commons.AnnotatableInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;

public class AnnotatationsInvocationHandler
extends AbstractInvocationHandler {
    private final EntityInvocationHandler entityHandler;
    private final AbstractStructuredInvocationHandler targetHandler;

    static AnnotatationsInvocationHandler getInstance(EntityInvocationHandler entityHandler, AbstractStructuredInvocationHandler targetHandler) {
        return new AnnotatationsInvocationHandler((AbstractService<?>)(targetHandler == null ? (entityHandler == null ? null : entityHandler.service) : targetHandler.service), entityHandler, targetHandler);
    }

    private AnnotatationsInvocationHandler(AbstractService<?> service, EntityInvocationHandler entityHandler, AbstractStructuredInvocationHandler targetHandler) {
        super(service);
        this.targetHandler = targetHandler;
        this.entityHandler = entityHandler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isSelfMethod(method)) {
            return this.invokeSelfMethod(method, args);
        }
        if (method.getName().startsWith("get") && method.getName().endsWith("Annotations")) {
            Method getter = proxy.getClass().getInterfaces()[0].getMethod(method.getName(), new Class[0]);
            String propName = null;
            String navPropName = null;
            AnnotationsForProperty annForProp = ClassUtils.getAnnotation(AnnotationsForProperty.class, getter);
            if (annForProp == null) {
                AnnotationsForNavigationProperty annForNavProp = ClassUtils.getAnnotation(AnnotationsForNavigationProperty.class, getter);
                if (annForNavProp == null) {
                    throw new UnsupportedOperationException("Unsupported method " + method.getName());
                }
                navPropName = annForNavProp.name();
            } else {
                propName = annForProp.name();
            }
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{method.getReturnType()}, (InvocationHandler)new AnnotatableInvocationHandler(this.service, propName, navPropName, this.entityHandler, this.targetHandler));
        }
        throw new NoSuchMethodException(method.getName());
    }
}

