/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.util.HashMap;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.api.serialization.ODataMetadataValidation;
import org.apache.olingo.client.core.metadatavalidator.CsdlTypeValidator;
import org.apache.olingo.client.core.metadatavalidator.EdmTypeValidator;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;

public class ODataMetadataValidationImpl
implements ODataMetadataValidation {
    public void validateMetadata(Edm edm) {
        HashMap<FullQualifiedName, EdmEntityType> edmEntityTypesMap = new HashMap<FullQualifiedName, EdmEntityType>();
        HashMap<FullQualifiedName, EdmComplexType> edmComplexTypesMap = new HashMap<FullQualifiedName, EdmComplexType>();
        HashMap<FullQualifiedName, EdmFunction> edmFunctionsMap = new HashMap<FullQualifiedName, EdmFunction>();
        HashMap<FullQualifiedName, EdmEntityContainer> edmContainersMap = new HashMap<FullQualifiedName, EdmEntityContainer>();
        HashMap<String, String> aliasNamespaceMap = new HashMap<String, String>();
        List edmSchemas = edm.getSchemas();
        for (EdmSchema edmSchema : edmSchemas) {
            Object edmEntityType2;
            List edmEntityTypes = edmSchema.getEntityTypes();
            for (Object edmEntityType2 : edmEntityTypes) {
                edmEntityTypesMap.put(edmEntityType2.getFullQualifiedName(), (EdmEntityType)edmEntityType2);
            }
            List edmComplexTypes = edmSchema.getComplexTypes();
            edmEntityType2 = edmComplexTypes.iterator();
            while (edmEntityType2.hasNext()) {
                EdmComplexType edmComplexType = (EdmComplexType)edmEntityType2.next();
                edmComplexTypesMap.put(edmComplexType.getFullQualifiedName(), edmComplexType);
            }
            List edmFunctions = edmSchema.getFunctions();
            for (EdmFunction edmFunction : edmFunctions) {
                edmFunctionsMap.put(edmFunction.getFullQualifiedName(), edmFunction);
            }
            aliasNamespaceMap.put(edmSchema.getAlias(), edmSchema.getNamespace());
            if (edmSchema.getEntityContainer() == null) continue;
            edmContainersMap.put(edmSchema.getEntityContainer().getFullQualifiedName(), edmSchema.getEntityContainer());
        }
        EdmTypeValidator edmTypeValidator = new EdmTypeValidator(aliasNamespaceMap, edmContainersMap, edmEntityTypesMap, edmComplexTypesMap, edmFunctionsMap);
        edmTypeValidator.validateEdm();
    }

    public void validateMetadata(XMLMetadata xmlMetadata) {
        HashMap<FullQualifiedName, CsdlEntityType> csdlEntityTypesMap = new HashMap<FullQualifiedName, CsdlEntityType>();
        HashMap<FullQualifiedName, CsdlComplexType> csdlComplexTypesMap = new HashMap<FullQualifiedName, CsdlComplexType>();
        HashMap<FullQualifiedName, CsdlAction> csdlActionsMap = new HashMap<FullQualifiedName, CsdlAction>();
        HashMap<FullQualifiedName, CsdlFunction> csdlFunctionsMap = new HashMap<FullQualifiedName, CsdlFunction>();
        HashMap<FullQualifiedName, CsdlEntityContainer> csdlContainersMap = new HashMap<FullQualifiedName, CsdlEntityContainer>();
        HashMap<String, String> aliasNamespaceMap = new HashMap<String, String>();
        List csdlSchemas = xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            Object csdlEntityType2;
            List csdlEntityTypes = csdlSchema.getEntityTypes();
            for (Object csdlEntityType2 : csdlEntityTypes) {
                csdlEntityTypesMap.put(new FullQualifiedName(csdlSchema.getNamespace(), csdlEntityType2.getName()), (CsdlEntityType)csdlEntityType2);
            }
            List csdlComplexTypes = csdlSchema.getComplexTypes();
            csdlEntityType2 = csdlComplexTypes.iterator();
            while (csdlEntityType2.hasNext()) {
                CsdlComplexType csdlComplexType = (CsdlComplexType)csdlEntityType2.next();
                csdlComplexTypesMap.put(new FullQualifiedName(csdlSchema.getNamespace(), csdlComplexType.getName()), csdlComplexType);
            }
            List csdlActions = csdlSchema.getActions();
            for (CsdlAction csdlAction : csdlActions) {
                csdlActionsMap.put(new FullQualifiedName(csdlSchema.getNamespace(), csdlAction.getName()), csdlAction);
            }
            List csdlFunctions = csdlSchema.getFunctions();
            for (CsdlFunction csdlFunction : csdlFunctions) {
                csdlFunctionsMap.put(new FullQualifiedName(csdlSchema.getNamespace(), csdlFunction.getName()), csdlFunction);
            }
            aliasNamespaceMap.put(csdlSchema.getAlias(), csdlSchema.getNamespace());
            if (csdlSchema.getEntityContainer() == null) continue;
            csdlContainersMap.put(new FullQualifiedName(csdlSchema.getNamespace(), csdlSchema.getEntityContainer().getName()), csdlSchema.getEntityContainer());
        }
        CsdlTypeValidator csdlTypeValidator = new CsdlTypeValidator(aliasNamespaceMap, csdlContainersMap, csdlEntityTypesMap, csdlComplexTypesMap, csdlActionsMap, csdlFunctionsMap);
        csdlTypeValidator.validateMetadataXML();
    }

    public boolean isV4Metadata(XMLMetadata xmlMetadata) throws Exception {
        return new CsdlTypeValidator().isV4MetaData(xmlMetadata);
    }

    public boolean isServiceDocument(XMLMetadata xmlMetadata) {
        return new CsdlTypeValidator().isServiceDocument(xmlMetadata);
    }
}

