/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;

@JsonDeserialize(using=EntitySetDeserializer.class)
class ClientCsdlEntitySet
extends CsdlEntitySet
implements Serializable {
    private static final long serialVersionUID = -5553885465204370676L;

    ClientCsdlEntitySet() {
    }

    static class EntitySetDeserializer
    extends AbstractClientCsdlEdmDeserializer<CsdlEntitySet> {
        EntitySetDeserializer() {
        }

        @Override
        protected CsdlEntitySet doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlEntitySet entitySet = new ClientCsdlEntitySet();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        entitySet.setName(jp.nextTextValue());
                    } else if ("EntityType".equals(jp.getCurrentName())) {
                        entitySet.setType(jp.nextTextValue());
                    } else if ("IncludeInServiceDocument".equals(jp.getCurrentName())) {
                        entitySet.setIncludeInServiceDocument(BooleanUtils.toBoolean(jp.nextTextValue()));
                    } else if ("NavigationPropertyBinding".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        entitySet.getNavigationPropertyBindings().add(jp.readValueAs(ClientCsdlNavigationPropertyBinding.class));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        entitySet.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return entitySet;
        }
    }
}

