/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.groups;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.admin.AdminBasePanel;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.admin.groups.GroupForm;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.data.DataViewContainer;
import org.apache.openmeetings.web.data.OmOrderByBorder;
import org.apache.openmeetings.web.data.SearchableGroupAdminDataProvider;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.danekja.java.util.function.serializable.SerializableConsumer;

@AuthorizeInstantiation(value={"ADMIN", "GROUP_ADMIN"})
public class GroupsPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    private GroupForm form;

    public GroupsPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        final WebMarkupContainer listContainer = new WebMarkupContainer("listContainer");
        SearchableDataView<Group> dataView = new SearchableDataView<Group>("groupList", new SearchableGroupAdminDataProvider(GroupDao.class)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<Group> item) {
                Group g = (Group)item.getModelObject();
                item.add(new Component[]{new Label("id")});
                item.add(new Component[]{new WebMarkupContainer("default").setVisible(g.getId().equals(OpenmeetingsVariables.getDefaultGroup()))});
                Label name = new Label("name");
                if (g.isExternal()) {
                    name.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"external"))});
                }
                item.add(new Component[]{name});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    GroupsPanel.this.form.setNewRecordVisible(false);
                    GroupsPanel.this.form.setModelObject(g);
                    GroupsPanel.this.form.updateView((AjaxRequestTarget)target);
                    target.add(new Component[]{listContainer});
                })});
                item.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)GroupsPanel.this.getRowClass(g.getId(), ((Group)GroupsPanel.this.form.getModelObject()).getId()))});
            }
        };
        boolean isGroupAdmin = AuthLevelUtil.hasGroupAdminLevel(WebSession.getRights());
        Iterator iter = dataView.getDataProvider().iterator(0L, 1L);
        Group g = iter.hasNext() ? (Group)iter.next() : new Group();
        this.form = new GroupForm("form", listContainer, isGroupAdmin ? g : new Group());
        this.add(new Component[]{this.form});
        this.add(new Component[]{listContainer.add(new Component[]{dataView}).setOutputMarkupId(true)});
        PagedEntityListPanel navigator = new PagedEntityListPanel("navigator", dataView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                target.add(new Component[]{listContainer});
            }
        };
        DataViewContainer<Group> container = new DataViewContainer<Group>(listContainer, dataView, navigator);
        container.addLink(new OmOrderByBorder<Group>("orderById", "id", container)).addLink(new OmOrderByBorder<Group>("orderByName", "name", container));
        this.add((Component[])container.getLinks());
        this.add(new Component[]{navigator});
    }
}

