/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.app;

import com.github.openjson.JSONObject;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.IUserManager;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.dto.user.OAuthUser;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IClientManager;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.service.mail.EmailManager;
import org.apache.openmeetings.util.OmException;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.openmeetings.util.crypt.ICrypt;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.pages.auth.SignInPage;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.request.flow.RedirectToUrlException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserManager
implements IUserManager {
    private static final Logger log = LoggerFactory.getLogger(UserManager.class);
    @Inject
    private ConfigurationDao cfgDao;
    @Inject
    private GroupDao groupDao;
    @Inject
    private UserDao userDao;
    @Inject
    private EmailManager emailManager;
    @Inject
    private IClientManager cm;
    private HttpClient httpClient;

    private static boolean sendConfirmation() {
        String baseURL = OpenmeetingsVariables.getBaseUrl();
        return !Strings.isEmpty((String)baseURL) && OpenmeetingsVariables.isSendVerificationEmail();
    }

    public Object registerUser(String login, String password, String lastname, String firstname, String email, String country, long languageId, String tzId) {
        try {
            if (OpenmeetingsVariables.isAllowRegisterFrontend()) {
                User u = UserDao.getNewUserInstance(null);
                u.setFirstname(firstname);
                u.setLogin(login);
                u.setLastname(lastname);
                u.getAddress().setCountry(country);
                u.getAddress().setEmail(email);
                u.setTimeZoneId(TimezoneUtil.getTimeZone((String)tzId).getID());
                u.setLanguageId(languageId != 0L ? languageId : 1L);
                u.addGroup(this.groupDao.get(OpenmeetingsVariables.getDefaultGroup()));
                Object user = this.registerUser(u, password, null);
                if (user instanceof User && UserManager.sendConfirmation()) {
                    log.debug("User created, confirmation should be sent");
                    return -40L;
                }
                log.debug("User creation result: {}", user);
                return user;
            }
            log.warn("Frontend registering is disabled");
            return "error.reg.disabled";
        }
        catch (Exception e) {
            log.error("[registerUser]", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object registerUser(User u, String password, String hash) throws OmException, NoSuchAlgorithmException {
        boolean checkEmail;
        String login = u.getLogin();
        if (Strings.isEmpty((String)login) || login.length() < OpenmeetingsVariables.getMinLoginLength()) return "error.short.login";
        boolean checkName = this.userDao.checkLogin(login, User.Type.USER, null, null);
        String email = u.getAddress() == null ? null : u.getAddress().getEmail();
        boolean bl = checkEmail = Strings.isEmpty((String)email) || this.userDao.checkEmail(email, User.Type.USER, null, null);
        if (checkName && checkEmail) {
            String ahash;
            String string = ahash = Strings.isEmpty((String)hash) ? UUID.randomUUID().toString() : hash;
            if (User.Type.EXTERNAL != u.getType() && !Strings.isEmpty((String)email)) {
                this.emailManager.sendMail(login, email, ahash, UserManager.sendConfirmation(), Long.valueOf(u.getLanguageId()));
            }
            if (UserManager.sendConfirmation() && u.getRights().contains(User.Right.LOGIN)) {
                u.getRights().remove(User.Right.LOGIN);
            }
            u.setActivatehash(ahash);
            if (!Strings.isEmpty((String)password)) {
                u.updatePassword(password);
            }
            u = this.userDao.update(u, null);
            log.debug("Added user-Id {}", (Object)u.getId());
            if (u.getId() == null) return OmException.UNKNOWN.getKey();
            return u;
        }
        if (checkName) return "error.email.inuse";
        return "error.login.inuse";
    }

    public boolean kickUsersByRoomId(Long roomId) {
        try {
            this.cm.streamByRoom(roomId).forEach(Application::kickUser);
            return true;
        }
        catch (Exception err) {
            log.error("[kickUsersByRoomId]", (Throwable)err);
            return false;
        }
    }

    public boolean kickExternal(Long roomId, String externalType, String externalId) {
        Boolean result = false;
        try {
            if (roomId == null) {
                return result;
            }
            User u = this.userDao.getExternalUser(externalId, externalType);
            if (u != null) {
                for (Client c : this.cm.listByUser(u.getId())) {
                    if (!roomId.equals(c.getRoomId())) continue;
                    Application.kickUser(c);
                    result = true;
                }
            }
        }
        catch (Exception e) {
            log.error("[kickExternal]", (Throwable)e);
        }
        return result;
    }

    public Long getLanguage(Locale loc) {
        return LabelDao.getLanguage((Locale)loc, (Long)OpenmeetingsVariables.getDefaultLang());
    }

    public void initHttpClient() {
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(10L));
        boolean ignoreBadSsl = this.cfgDao.getBool("oauth2.ignore.bad.ssl", false);
        System.setProperty("jdk.internal.httpclient.disableHostnameVerification", String.valueOf(ignoreBadSsl));
        if (ignoreBadSsl) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLParameters sslParams = new SSLParameters();
                sslParams.setEndpointIdentificationAlgorithm("");
                builder.sslContext(sslContext).sslParameters(sslParams);
            }
            catch (Exception e) {
                log.error("[initHttpClient]", (Throwable)e);
            }
        }
        this.httpClient = builder.build();
    }

    public User loginOAuth(String code, OAuthServer server) throws IOException, NoSuchAlgorithmException, InterruptedException {
        if (code == null) {
            UserManager.showAuth(server);
            return null;
        }
        log.debug("OAuth response code={}", (Object)code);
        AuthInfo authInfo = this.getToken(code, server);
        if (authInfo == null) {
            return null;
        }
        log.debug("OAuthInfo={}", (Object)authInfo);
        OAuthUser user = this.getAuthParams(authInfo, code, server);
        if (!this.userDao.validLogin(user.getLogin())) {
            log.error("Invalid login, please check parameters");
            return null;
        }
        User u = this.userDao.getByLogin(user.getLogin(), User.Type.OAUTH, server.getId());
        if (!this.userDao.checkEmail(user.getEmail(), User.Type.OAUTH, server.getId(), u == null ? null : u.getId())) {
            log.error("Another user with the same email exists");
            return null;
        }
        if (u == null) {
            User fUser = UserDao.getNewUserInstance(null);
            fUser.setType(User.Type.OAUTH);
            fUser.getRights().remove(User.Right.LOGIN);
            fUser.setDomainId(server.getId());
            fUser.addGroup(this.groupDao.get(OpenmeetingsVariables.getDefaultGroup()));
            for (Map.Entry entry : user.getUserData().entrySet()) {
                String expression = (String)entry.getKey();
                PropertyResolver.setValue((String)expression, (Object)fUser, entry.getValue(), (PropertyResolverConverter)new LanguageConverter(expression, fUser, null, null));
            }
            fUser.setShowContactDataToContacts(true);
            u = fUser;
        }
        u.setLastlogin(new Date());
        ICrypt crypt = CryptProvider.get();
        u = this.userDao.update(u, crypt.randomPassword(25), Long.valueOf(-1L));
        return u;
    }

    private static Map<String, String> getInitParams(OAuthServer s) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("{$client_id}", s.getClientId());
        params.put("{$redirect_uri}", UserManager.getRedirectUri(s));
        params.put("{$state}", UUID.randomUUID().toString());
        return params;
    }

    public static void showAuth(OAuthServer s) {
        String authUrl = UserManager.prepareUrl(s.getRequestKeyUrl(), UserManager.getInitParams(s));
        log.debug("redirectUrl={}", (Object)authUrl);
        throw new RedirectToUrlException(authUrl);
    }

    private static String prepareUrl(String urlTemplate, Map<String, String> params) {
        String result = urlTemplate;
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (e.getValue() == null) continue;
            result = result.replace(e.getKey(), URLEncoder.encode(e.getValue(), StandardCharsets.UTF_8));
        }
        return result;
    }

    public static String getRedirectUri(OAuthServer server) {
        String result = "";
        if (server.getId() != null) {
            String base = OpenmeetingsVariables.getBaseUrl();
            result = Application.urlForPage(SignInPage.class, new PageParameters().add("oauthid", (Object)server.getId()), base);
        }
        return result;
    }

    private static Map<String, String> getParams(OAuthServer s, String code, AuthInfo authInfo) {
        Map<String, String> params = UserManager.getInitParams(s);
        params.put("{$client_id}", s.getClientId());
        params.put("{$client_secret}", s.getClientSecret());
        if (authInfo != null) {
            params.put("{$access_token}", authInfo.accessToken);
            params.put("{$user_id}", authInfo.userId);
        }
        if (code != null) {
            params.put("{$code}", code);
        }
        return params;
    }

    private static HttpRequest.Builder setNoCache(HttpRequest.Builder builder) {
        return builder.header("Cache-Control", "no-cache, no-store, must-revalidate").header("Pragma", "no-cache").header("Expires", "0");
    }

    String doRequest(HttpRequest request) throws IOException, InterruptedException {
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
    }

    private AuthInfo getToken(String code, OAuthServer server) throws IOException, InterruptedException {
        String requestTokenParams = UserManager.prepareUrl(server.getRequestTokenAttributes(), UserManager.getParams(server, code, null));
        HttpRequest request = UserManager.setNoCache(HttpRequest.newBuilder().uri(URI.create(server.getRequestTokenUrl())).header("Content-Type", "application/x-www-form-urlencoded").header("charset", StandardCharsets.UTF_8.name()).method(server.getRequestTokenMethod().name(), HttpRequest.BodyPublishers.ofString(requestTokenParams))).build();
        String resp = this.doRequest(request);
        AuthInfo result = new AuthInfo(resp);
        if (result.accessToken == null) {
            log.error("Response doesn't contain access_token field:\n {}", (Object)resp);
            return null;
        }
        return result;
    }

    private OAuthUser getAuthParams(AuthInfo authInfo, String code, OAuthServer server) throws IOException, InterruptedException {
        String requestInfoUrl = UserManager.prepareUrl(server.getRequestInfoUrl(), UserManager.getParams(server, code, authInfo));
        HttpRequest.Builder builder = UserManager.setNoCache(HttpRequest.newBuilder().uri(URI.create(requestInfoUrl)));
        if (server.getRequestInfoMethod() == OAuthServer.RequestInfoMethod.HEADER) {
            builder.header("Authorization", "Bearer " + authInfo.accessToken);
        } else {
            builder.method(server.getRequestInfoMethod().name(), HttpRequest.BodyPublishers.noBody());
        }
        String json = this.doRequest(builder.build());
        log.debug("User info={}", (Object)json);
        return new OAuthUser(json, server);
    }

    private static class AuthInfo {
        final String accessToken;
        final String refreshToken;
        final String tokenType;
        final String userId;
        final long expiresIn;

        AuthInfo(String jsonStr) {
            log.debug("AuthInfo={}", (Object)jsonStr);
            JSONObject json = new JSONObject(jsonStr);
            this.accessToken = json.optString("access_token");
            this.refreshToken = json.optString("refresh_token");
            this.tokenType = json.optString("token_type");
            this.userId = json.optString("user_id");
            this.expiresIn = json.optLong("expires_in");
        }

        public String toString() {
            return "AuthInfo [accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", tokenType=" + this.tokenType + ", userId=" + this.userId + ", expiresIn=" + this.expiresIn + "]";
        }
    }

    private class LanguageConverter
    extends PropertyResolverConverter {
        private static final long serialVersionUID = 1L;
        final String expression;
        final User fUser;

        public LanguageConverter(String expression, User fUser, IConverterLocator converterSupplier, Locale locale) {
            super(converterSupplier, locale);
            this.expression = expression;
            this.fUser = fUser;
        }

        public <T> T convert(Object object, Class<T> clz) {
            if ("languageId".equals(this.expression) && Long.class.isAssignableFrom(clz)) {
                Locale loc;
                Long language = 1L;
                String locale = (String)object;
                if (locale != null && (loc = Locale.forLanguageTag(locale)) != null) {
                    language = UserManager.this.getLanguage(loc);
                    this.fUser.setLanguageId(language.longValue());
                    this.fUser.getAddress().setCountry(loc.getCountry());
                }
                return (T)language;
            }
            return (T)object;
        }

        protected <C> String convertToString(C object, Locale locale) {
            return String.valueOf(object);
        }
    }
}

