/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.transport.jsonrpc;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.kurento.client.Continuation;
import org.kurento.client.TransactionExecutionException;
import org.kurento.client.internal.client.DefaultContinuation;
import org.kurento.client.internal.client.RomClient;
import org.kurento.client.internal.client.RomEventHandler;
import org.kurento.client.internal.client.operation.Operation;
import org.kurento.client.internal.server.KurentoServerException;
import org.kurento.client.internal.server.KurentoServerTransportException;
import org.kurento.client.internal.transport.jsonrpc.JsonResponseUtils;
import org.kurento.client.internal.transport.serialization.ParamsFlattener;
import org.kurento.jsonrpc.DefaultJsonRpcHandler;
import org.kurento.jsonrpc.JsonRpcErrorException;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.Props;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RomClientJsonRpcClient
implements RomClient {
    private static final Logger log = LoggerFactory.getLogger(RomClientJsonRpcClient.class);
    private final JsonRpcClient client;

    public RomClientJsonRpcClient(JsonRpcClient client) {
        this.client = client;
    }

    @Override
    public Object invoke(String objectRef, String operationName, Props operationParams, Type type) {
        return this.invoke(objectRef, operationName, operationParams, type, null);
    }

    @Override
    public <E> E invoke(String objectRef, String operationName, Props operationParams, Class<E> clazz) {
        return (E)this.invoke(objectRef, operationName, operationParams, (Type)clazz);
    }

    @Override
    public Object invoke(String objectRef, String operationName, Props operationParams, Type type, Continuation<?> cont) {
        RequestAndResponseType reqres = this.createInvokeRequest(objectRef, operationName, operationParams, type, false);
        return this.sendRequest(reqres.request, reqres.responseType, null, cont);
    }

    @Override
    public String subscribe(String objectRef, String type) {
        return this.subscribe(objectRef, type, null);
    }

    @Override
    public String subscribe(String objectRef, String eventType, Continuation<String> cont) {
        RequestAndResponseType reqres = this.createSubscribeRequest(objectRef, eventType);
        return this.sendRequest(reqres.request, reqres.responseType, null, cont);
    }

    @Override
    public void unsubscribe(String objectRef, String listenerSubscription) {
        this.unsubscribe(objectRef, listenerSubscription, null);
    }

    @Override
    public void unsubscribe(String objectRef, String listenerSubscription, Continuation<Void> cont) {
        RequestAndResponseType reqres = this.createUnsubscribeRequest(objectRef, listenerSubscription);
        this.sendRequest(reqres.request, reqres.responseType, null, cont);
    }

    @Override
    public String create(String remoteClassName, Props constructorParams, Props genericProperties) {
        return this.create(remoteClassName, constructorParams, genericProperties, null);
    }

    @Override
    public String create(String remoteClassName, Props constructorParams, Props genericProperties, Continuation<String> cont) {
        RequestAndResponseType reqres = this.createCreateRequest(remoteClassName, constructorParams, genericProperties, false);
        return this.sendRequest(reqres.request, reqres.responseType, null, cont);
    }

    @Override
    public void release(String objectRef) {
        this.release(objectRef, null);
    }

    @Override
    public void release(String objectRef, Continuation<Void> cont) {
        RequestAndResponseType reqres = this.createReleaseRequest(objectRef);
        this.sendRequest(reqres.request, reqres.responseType, null, cont);
    }

    @Override
    public void addRomEventHandler(final RomEventHandler eventHandler) {
        this.client.setServerRequestHandler((JsonRpcHandler)new DefaultJsonRpcHandler<JsonObject>(){

            public void handleRequest(Transaction transaction, Request<JsonObject> request) throws Exception {
                RomClientJsonRpcClient.this.processEvent(eventHandler, request);
            }
        });
    }

    private void processEvent(RomEventHandler eventHandler, Request<JsonObject> request) {
        JsonObject params = (JsonObject)request.getParams();
        try {
            params = (JsonObject)params.get("value");
        }
        catch (Exception e) {
            log.trace("Exception processing event: getting value", (Throwable)e);
        }
        String objectRef = params.get("object").getAsString();
        String subscription = "";
        if (params.has("subscription")) {
            subscription = params.get("subscription").getAsString();
        }
        String type = params.get("type").getAsString();
        JsonObject jsonData = (JsonObject)params.get("data");
        Props data = (Props)JsonUtils.fromJson((JsonElement)jsonData, Props.class);
        eventHandler.processEvent(objectRef, subscription, type, data);
    }

    @Override
    public void destroy() {
        log.debug("Destroying RomClientJsonRpc");
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while closing JsonRpcClient", e);
        }
    }

    private <P, R> R sendRequest(Request<JsonObject> request, final Type responseType, final Function<P, R> processor, final Continuation<R> cont) {
        try {
            if (cont == null) {
                return this.processReqResult(responseType, processor, (JsonElement)this.client.sendRequest(request.getMethod(), request.getParams(), JsonElement.class));
            }
            this.client.sendRequest(request.getMethod(), (JsonObject)request.getParams(), (org.kurento.jsonrpc.client.Continuation)new org.kurento.jsonrpc.client.Continuation<JsonElement>(){

                public void onSuccess(JsonElement reqResult) {
                    Object methodResult = RomClientJsonRpcClient.this.processReqResult(responseType, processor, reqResult);
                    try {
                        cont.onSuccess(methodResult);
                    }
                    catch (Exception e) {
                        log.warn("[Continuation] error invoking OnSuccess implemented by client", (Throwable)e);
                    }
                }

                public void onError(Throwable cause) {
                    try {
                        cont.onError(cause);
                    }
                    catch (Exception e) {
                        log.warn("[Continuation] error invoking onError implemented by client", (Throwable)e);
                    }
                }
            });
            return null;
        }
        catch (IOException e) {
            String messageError = "Error connecting with server";
            log.error(messageError, (Throwable)e);
            throw new KurentoServerTransportException(messageError, e);
        }
        catch (JsonRpcErrorException e) {
            throw new KurentoServerException(e.getError());
        }
    }

    private <P, R> R processReqResult(Type type, Function<P, R> processor, JsonElement reqResult) {
        Object methodResult = JsonResponseUtils.convertFromResult(reqResult, type);
        if (processor == null) {
            return (R)methodResult;
        }
        return (R)processor.apply(methodResult);
    }

    public RequestAndResponseType createInvokeRequest(String objectRef, String operationName, Props operationParams, Type type, boolean inTx) {
        JsonObject params = new JsonObject();
        params.addProperty("object", objectRef);
        params.addProperty("operation", operationName);
        if (operationParams != null) {
            Props flatParams = ParamsFlattener.getInstance().flattenParams(operationParams, inTx);
            params.add("operationParams", (JsonElement)JsonUtils.toJsonObject((Object)flatParams));
        }
        return new RequestAndResponseType((Request<JsonObject>)new Request("invoke", (Object)params), type);
    }

    public RequestAndResponseType createReleaseRequest(String objectRef) {
        JsonObject params = JsonUtils.toJsonObject((Object)new Props("object", (Object)objectRef));
        return new RequestAndResponseType((Request<JsonObject>)new Request("release", (Object)params), (Type)((Object)Void.class));
    }

    public RequestAndResponseType createCreateRequest(String remoteClassName, Props constructorParams, Props genericProps, boolean inTx) {
        JsonObject params = new JsonObject();
        params.addProperty("type", remoteClassName);
        if (constructorParams != null) {
            Props flatParams = ParamsFlattener.getInstance().flattenParams(constructorParams, inTx);
            params.add("constructorParams", (JsonElement)JsonUtils.toJsonObject((Object)flatParams));
        }
        if (genericProps != null) {
            Props flatProperties = ParamsFlattener.getInstance().flattenParams(genericProps, inTx);
            params.add("properties", (JsonElement)JsonUtils.toJsonObject((Object)flatProperties));
        }
        return new RequestAndResponseType((Request<JsonObject>)new Request("create", (Object)params), (Type)((Object)String.class));
    }

    public RequestAndResponseType createSubscribeRequest(String objectRef, String eventType) {
        JsonObject params = JsonUtils.toJsonObject((Object)new Props("object", (Object)objectRef).add("type", (Object)eventType));
        return new RequestAndResponseType((Request<JsonObject>)new Request("subscribe", (Object)params), (Type)((Object)String.class));
    }

    public RequestAndResponseType createUnsubscribeRequest(String objectRef, String listenerSubscription) {
        JsonObject params = JsonUtils.toJsonObject((Object)new Props("object", (Object)objectRef).add("subscription", (Object)listenerSubscription));
        return new RequestAndResponseType((Request<JsonObject>)new Request("unsubscribe", (Object)params), (Type)((Object)Void.class));
    }

    @Override
    public void transaction(List<Operation> operations) {
        this.transaction(operations, null);
    }

    @Override
    public void transaction(final List<Operation> operations, final Continuation<Void> continuation) {
        JsonArray opJsons = new JsonArray();
        final ArrayList<RequestAndResponseType> opReqres = new ArrayList<RequestAndResponseType>();
        int numReq = 0;
        for (Operation op : operations) {
            RequestAndResponseType reqres = op.createRequest(this);
            opReqres.add(reqres);
            reqres.request.setId(Integer.valueOf(numReq));
            opJsons.add(JsonUtils.toJsonElement(reqres.request));
            ++numReq;
        }
        JsonObject params = new JsonObject();
        params.add("operations", (JsonElement)opJsons);
        DefaultContinuation<List<Response<JsonElement>>> wrappedContinuation = null;
        if (continuation != null) {
            wrappedContinuation = new DefaultContinuation<List<Response<JsonElement>>>(continuation){

                @Override
                public void onSuccess(List<Response<JsonElement>> responses) throws Exception {
                    RomClientJsonRpcClient.this.processTransactionResponse(operations, opReqres, responses);
                    continuation.onSuccess(null);
                }
            };
        }
        List<Response<JsonElement>> responses = this.sendRequest((Request<JsonObject>)new Request("transaction", (Object)params), new TypeToken<List<Response<JsonElement>>>(){}.getType(), null, wrappedContinuation);
        if (continuation == null) {
            this.processTransactionResponse(operations, opReqres, responses);
        }
    }

    private void processTransactionResponse(List<Operation> operations, List<RequestAndResponseType> opReqres, List<Response<JsonElement>> responses) {
        Response<JsonElement> response;
        Operation op;
        int i;
        TransactionExecutionException ex = null;
        for (i = 0; i < operations.size(); ++i) {
            op = operations.get(i);
            response = responses.get(i);
            if (!response.isError()) continue;
            ex = new TransactionExecutionException(op, response.getError());
            break;
        }
        if (ex != null) {
            for (i = 0; i < operations.size(); ++i) {
                op = operations.get(i);
                op.rollback(ex);
            }
            throw ex;
        }
        for (i = 0; i < operations.size(); ++i) {
            op = operations.get(i);
            response = responses.get(i);
            RequestAndResponseType reqres = opReqres.get(i);
            op.processResponse(this.processReqResult(reqres.responseType, null, (JsonElement)response.getResult()));
        }
    }

    @Override
    public boolean isClosed() {
        return this.client.isClosedByUser();
    }

    public class RequestAndResponseType {
        public Request<JsonObject> request;
        public Type responseType;

        public RequestAndResponseType(Request<JsonObject> request, Type responseType) {
            this.request = request;
            this.responseType = responseType;
        }
    }
}

