/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.client.cache.impl.ClientCacheStatisticsImpl;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Timer;
import java.util.function.BiConsumer;

final class CacheStatsHandler {
    private final SerializationService serializationService;
    private final ClientCacheStatisticsImpl statistics;

    CacheStatsHandler(SerializationService serializationService) {
        this.serializationService = serializationService;
        this.statistics = new ClientCacheStatisticsImpl(System.currentTimeMillis());
    }

    ClientCacheStatisticsImpl getStatistics() {
        return this.statistics;
    }

    void onReplace(boolean isGet, long startNanos, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(Timer.nanosElapsed(startNanos));
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCachePuts();
                this.statistics.addPutTimeNanos(Timer.nanosElapsed(startNanos));
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(response)) {
            this.statistics.increaseCacheHits();
            this.statistics.increaseCachePuts();
            this.statistics.addPutTimeNanos(Timer.nanosElapsed(startNanos));
        } else {
            this.statistics.increaseCacheMisses();
        }
    }

    <T> BiConsumer<T, Throwable> newOnReplaceCallback(long startNanos) {
        return (response, throwable) -> {
            if (throwable == null) {
                this.onReplace(true, startNanos, this.toObject(response));
            }
        };
    }

    void onPutIfAbsent(long startNanos, boolean saved) {
        if (saved) {
            this.statistics.increaseCachePuts();
            this.statistics.increaseCacheMisses();
            this.statistics.addPutTimeNanos(Timer.nanosElapsed(startNanos));
        }
    }

    BiConsumer<Boolean, Throwable> newOnPutIfAbsentCallback(long startNanos) {
        return (responseData, throwable) -> {
            if (throwable == null) {
                Object response = this.toObject(responseData);
                this.onPutIfAbsent(startNanos, (Boolean)response);
            }
        };
    }

    void onPut(boolean isGet, long startNanos, boolean cacheHit) {
        this.statistics.increaseCachePuts();
        this.statistics.addPutTimeNanos(Timer.nanosElapsed(startNanos));
        if (isGet) {
            this.statistics.addGetTimeNanos(Timer.nanosElapsed(startNanos));
            if (cacheHit) {
                this.statistics.increaseCacheHits();
            } else {
                this.statistics.increaseCacheMisses();
            }
        }
    }

    <T> BiConsumer<T, Throwable> newOnPutCallback(boolean isGet, long startNanos) {
        return (responseData, throwable) -> {
            if (throwable == null) {
                this.onPut(isGet, startNanos, responseData != null);
            }
        };
    }

    void onRemove(boolean isGet, long startNanos, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(Timer.nanosElapsed(startNanos));
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCacheRemovals();
                this.statistics.addRemoveTimeNanos(Timer.nanosElapsed(startNanos));
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(this.toObject(response))) {
            this.statistics.increaseCacheRemovals();
            this.statistics.addRemoveTimeNanos(Timer.nanosElapsed(startNanos));
        }
    }

    <T> BiConsumer<T, Throwable> newOnRemoveCallback(boolean isGet, long startNanos) {
        return (v, throwable) -> {
            if (throwable == null) {
                this.onRemove(isGet, startNanos, v);
            }
        };
    }

    void onGet(long startNanos, boolean responseReceived) {
        if (responseReceived) {
            this.statistics.increaseCacheHits();
        } else {
            this.statistics.increaseCacheMisses();
        }
        this.statistics.addGetTimeNanos(Timer.nanosElapsed(startNanos));
    }

    <T> BiConsumer<T, Throwable> newOnGetCallback(long startNanos) {
        return (response, throwable) -> {
            if (throwable == null) {
                this.onGet(startNanos, response != null);
            }
        };
    }

    void onBatchRemove(long startNanos, int batchSize) {
        this.statistics.increaseCacheRemovals(batchSize);
        this.statistics.addRemoveTimeNanos(Timer.nanosElapsed(startNanos));
    }

    void onBatchGet(long startNanos, int batchSize) {
        this.statistics.increaseCacheHits(batchSize);
        this.statistics.addGetTimeNanos(Timer.nanosElapsed(startNanos));
    }

    void onBatchPut(long startNanos, int batchSize) {
        this.statistics.increaseCachePuts(batchSize);
        this.statistics.addPutTimeNanos(Timer.nanosElapsed(startNanos));
    }

    void clear() {
        this.statistics.clear();
    }

    private Object toObject(Object responseData) {
        return this.serializationService.toObject(responseData);
    }
}

