/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ByteArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListUUIDListIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MemberInfoCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.MemberInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public final class ClientAuthenticationCodec {
    public static final int REQUEST_MESSAGE_TYPE = 256;
    public static final int RESPONSE_MESSAGE_TYPE = 257;
    private static final int REQUEST_UUID_FIELD_OFFSET = 16;
    private static final int REQUEST_SERIALIZATION_VERSION_FIELD_OFFSET = 33;
    private static final int REQUEST_ROUTING_MODE_FIELD_OFFSET = 34;
    private static final int REQUEST_CP_DIRECT_TO_LEADER_ROUTING_FIELD_OFFSET = 35;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 36;
    private static final int RESPONSE_STATUS_FIELD_OFFSET = 13;
    private static final int RESPONSE_MEMBER_UUID_FIELD_OFFSET = 14;
    private static final int RESPONSE_SERIALIZATION_VERSION_FIELD_OFFSET = 31;
    private static final int RESPONSE_PARTITION_COUNT_FIELD_OFFSET = 32;
    private static final int RESPONSE_CLUSTER_ID_FIELD_OFFSET = 36;
    private static final int RESPONSE_FAILOVER_SUPPORTED_FIELD_OFFSET = 53;
    private static final int RESPONSE_MEMBER_LIST_VERSION_FIELD_OFFSET = 54;
    private static final int RESPONSE_PARTITION_LIST_VERSION_FIELD_OFFSET = 58;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 62;

    private ClientAuthenticationCodec() {
    }

    public static ClientMessage encodeRequest(String clusterName, @Nullable String username, @Nullable String password, @Nullable UUID uuid, String clientType, byte serializationVersion, String clientHazelcastVersion, String clientName, Collection<String> labels, byte routingMode, boolean cpDirectToLeaderRouting) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Client.Authentication");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[36], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 256);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, uuid);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 33, serializationVersion);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 34, routingMode);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 35, cpDirectToLeaderRouting);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, clusterName);
        CodecUtil.encodeNullable(clientMessage, username, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, password, StringCodec::encode);
        StringCodec.encode(clientMessage, clientType);
        StringCodec.encode(clientMessage, clientHazelcastVersion);
        StringCodec.encode(clientMessage, clientName);
        ListMultiFrameCodec.encode(clientMessage, labels, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.serializationVersion = FixedSizeTypesCodec.decodeByte(initialFrame.content, 33);
        if (initialFrame.content.length >= 35) {
            request.routingMode = FixedSizeTypesCodec.decodeByte(initialFrame.content, 34);
            request.isRoutingModeExists = true;
        } else {
            request.isRoutingModeExists = false;
        }
        if (initialFrame.content.length >= 36) {
            request.cpDirectToLeaderRouting = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 35);
            request.isCpDirectToLeaderRoutingExists = true;
        } else {
            request.isCpDirectToLeaderRoutingExists = false;
        }
        request.clusterName = StringCodec.decode(iterator);
        request.username = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.password = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.clientType = StringCodec.decode(iterator);
        request.clientHazelcastVersion = StringCodec.decode(iterator);
        request.clientName = StringCodec.decode(iterator);
        request.labels = ListMultiFrameCodec.decode(iterator, StringCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse(byte status, @Nullable Address address, @Nullable UUID memberUuid, byte serializationVersion, String serverHazelcastVersion, int partitionCount, UUID clusterId, boolean failoverSupported, @Nullable Collection<Integer> tpcPorts, @Nullable byte[] tpcToken, int memberListVersion, Collection<MemberInfo> memberInfos, int partitionListVersion, Collection<Map.Entry<UUID, List<Integer>>> partitions, Map<String, String> keyValuePairs) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[62], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 257);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 13, status);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 14, memberUuid);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 31, serializationVersion);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 32, partitionCount);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 36, clusterId);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 53, failoverSupported);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 54, memberListVersion);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 58, partitionListVersion);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, address, AddressCodec::encode);
        StringCodec.encode(clientMessage, serverHazelcastVersion);
        CodecUtil.encodeNullable(clientMessage, tpcPorts, ListIntegerCodec::encode);
        CodecUtil.encodeNullable(clientMessage, tpcToken, ByteArrayCodec::encode);
        ListMultiFrameCodec.encode(clientMessage, memberInfos, MemberInfoCodec::encode);
        EntryListUUIDListIntegerCodec.encode(clientMessage, partitions);
        MapCodec.encode(clientMessage, keyValuePairs, StringCodec::encode, StringCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.status = FixedSizeTypesCodec.decodeByte(initialFrame.content, 13);
        response.memberUuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 14);
        response.serializationVersion = FixedSizeTypesCodec.decodeByte(initialFrame.content, 31);
        response.partitionCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 32);
        response.clusterId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 36);
        response.failoverSupported = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 53);
        if (initialFrame.content.length >= 58) {
            response.memberListVersion = FixedSizeTypesCodec.decodeInt(initialFrame.content, 54);
            response.isMemberListVersionExists = true;
        } else {
            response.isMemberListVersionExists = false;
        }
        if (initialFrame.content.length >= 62) {
            response.partitionListVersion = FixedSizeTypesCodec.decodeInt(initialFrame.content, 58);
            response.isPartitionListVersionExists = true;
        } else {
            response.isPartitionListVersionExists = false;
        }
        response.address = CodecUtil.decodeNullable(iterator, AddressCodec::decode);
        response.serverHazelcastVersion = StringCodec.decode(iterator);
        if (iterator.hasNext()) {
            response.tpcPorts = CodecUtil.decodeNullable(iterator, ListIntegerCodec::decode);
            response.isTpcPortsExists = true;
        } else {
            response.isTpcPortsExists = false;
        }
        if (iterator.hasNext()) {
            response.tpcToken = CodecUtil.decodeNullable(iterator, ByteArrayCodec::decode);
            response.isTpcTokenExists = true;
        } else {
            response.isTpcTokenExists = false;
        }
        if (iterator.hasNext()) {
            response.memberInfos = ListMultiFrameCodec.decode(iterator, MemberInfoCodec::decode);
            response.isMemberInfosExists = true;
        } else {
            response.isMemberInfosExists = false;
        }
        if (iterator.hasNext()) {
            response.partitions = EntryListUUIDListIntegerCodec.decode(iterator);
            response.isPartitionsExists = true;
        } else {
            response.isPartitionsExists = false;
        }
        if (iterator.hasNext()) {
            response.keyValuePairs = MapCodec.decode(iterator, StringCodec::decode, StringCodec::decode);
            response.isKeyValuePairsExists = true;
        } else {
            response.isKeyValuePairsExists = false;
        }
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String clusterName;
        @Nullable
        public String username;
        @Nullable
        public String password;
        @Nullable
        public UUID uuid;
        public String clientType;
        public byte serializationVersion;
        public String clientHazelcastVersion;
        public String clientName;
        public List<String> labels;
        public byte routingMode;
        public boolean cpDirectToLeaderRouting;
        public boolean isRoutingModeExists;
        public boolean isCpDirectToLeaderRoutingExists;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public byte status;
        @Nullable
        public Address address;
        @Nullable
        public UUID memberUuid;
        public byte serializationVersion;
        public String serverHazelcastVersion;
        public int partitionCount;
        public UUID clusterId;
        public boolean failoverSupported;
        @Nullable
        public List<Integer> tpcPorts;
        @Nullable
        public byte[] tpcToken;
        public int memberListVersion;
        public List<MemberInfo> memberInfos;
        public int partitionListVersion;
        public List<Map.Entry<UUID, List<Integer>>> partitions;
        public Map<String, String> keyValuePairs;
        public boolean isTpcPortsExists;
        public boolean isTpcTokenExists;
        public boolean isMemberListVersionExists;
        public boolean isMemberInfosExists;
        public boolean isPartitionListVersionExists;
        public boolean isPartitionsExists;
        public boolean isKeyValuePairsExists;
    }
}

