/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ReplicatedMapEntryViewHolderCodec;
import com.hazelcast.replicatedmap.impl.record.ReplicatedMapEntryViewHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public final class ReplicatedMapFetchEntryViewsCodec {
    public static final int REQUEST_MESSAGE_TYPE = 857088;
    public static final int RESPONSE_MESSAGE_TYPE = 857089;
    private static final int REQUEST_CURSOR_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_NEW_ITERATION_FIELD_OFFSET = 33;
    private static final int REQUEST_PARTITION_ID_FIELD_OFFSET = 34;
    private static final int REQUEST_BATCH_SIZE_FIELD_OFFSET = 38;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 42;
    private static final int RESPONSE_CURSOR_ID_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 30;

    private ReplicatedMapFetchEntryViewsCodec() {
    }

    public static ClientMessage encodeRequest(String name, UUID cursorId, boolean newIteration, int partitionId, int batchSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("ReplicatedMap.FetchEntryViews");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[42], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 857088);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, cursorId);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 33, newIteration);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 34, partitionId);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 38, batchSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.cursorId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.newIteration = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 33);
        request.partitionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 34);
        request.batchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 38);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(UUID cursorId, Collection<ReplicatedMapEntryViewHolder> entryViews) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 857089);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 13, cursorId);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, entryViews, ReplicatedMapEntryViewHolderCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.cursorId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 13);
        response.entryViews = ListMultiFrameCodec.decode(iterator, ReplicatedMapEntryViewHolderCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public UUID cursorId;
        public boolean newIteration;
        public int partitionId;
        public int batchSize;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public UUID cursorId;
        public List<ReplicatedMapEntryViewHolder> entryViews;
    }
}

