/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class FloatArrayCodec {
    private FloatArrayCodec() {
    }

    public static void encode(ClientMessage clientMessage, float[] array) {
        int itemCount = array.length;
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 4]);
        ByteBuffer.wrap(frame.content).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().put(array);
        clientMessage.add(frame);
    }

    public static float[] decode(ClientMessage.Frame frame) {
        int itemCount = frame.content.length / 4;
        float[] result = new float[itemCount];
        ByteBuffer.wrap(frame.content).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().get(result);
        return result;
    }

    public static float[] decode(ClientMessage.ForwardFrameIterator iterator) {
        return FloatArrayCodec.decode(iterator.next());
    }
}

