/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskHandlerImpl;
import java.util.UUID;

public final class ScheduledTaskHandlerCodec {
    private static final int UUID_FIELD_OFFSET = 0;
    private static final int PARTITION_ID_FIELD_OFFSET = 17;
    private static final int INITIAL_FRAME_SIZE = 21;

    private ScheduledTaskHandlerCodec() {
    }

    public static void encode(ClientMessage clientMessage, ScheduledTaskHandler scheduledTaskHandler) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[21]);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 0, scheduledTaskHandler.getUuid());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 17, scheduledTaskHandler.getPartitionId());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, scheduledTaskHandler.getSchedulerName());
        StringCodec.encode(clientMessage, scheduledTaskHandler.getTaskName());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static ScheduledTaskHandlerImpl decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        UUID uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 0);
        int partitionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 17);
        String schedulerName = StringCodec.decode(iterator);
        String taskName = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new ScheduledTaskHandlerImpl(uuid, partitionId, schedulerName, taskName);
    }
}

